/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathVisitor;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class ChangeSetCreateComplete {
    ChangeSetCreateComplete() {
    }

    static class IsValidationErrorMatcher
    extends WaiterAcceptor<DescribeChangeSetResult> {
        IsValidationErrorMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ValidationError".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsFAILEDMatcher
    extends WaiterAcceptor<DescribeChangeSetResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFAILEDMatcher() {
        }

        public boolean matches(DescribeChangeSetResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("Status");
        }
    }

    static class IsCREATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeChangeSetResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCREATE_COMPLETEMatcher() {
        }

        public boolean matches(DescribeChangeSetResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)ast.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)expectedResult, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"CREATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathField("Status");
        }
    }
}

