/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeTypeRegistrationRequest;
import com.amazonaws.services.cloudformation.waiters.ChangeSetCreateComplete;
import com.amazonaws.services.cloudformation.waiters.DescribeChangeSetFunction;
import com.amazonaws.services.cloudformation.waiters.DescribeStacksFunction;
import com.amazonaws.services.cloudformation.waiters.DescribeTypeRegistrationFunction;
import com.amazonaws.services.cloudformation.waiters.StackCreateComplete;
import com.amazonaws.services.cloudformation.waiters.StackDeleteComplete;
import com.amazonaws.services.cloudformation.waiters.StackExists;
import com.amazonaws.services.cloudformation.waiters.StackImportComplete;
import com.amazonaws.services.cloudformation.waiters.StackUpdateComplete;
import com.amazonaws.services.cloudformation.waiters.TypeRegistrationComplete;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AmazonCloudFormationWaiters {
    private final AmazonCloudFormation client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonCloudFormationWaiters");

    @SdkInternalApi
    public AmazonCloudFormationWaiters(AmazonCloudFormation client) {
        this.client = client;
    }

    public Waiter<DescribeStacksRequest> stackExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new StackExists.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackCreateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackCreateComplete.IsCREATE_COMPLETEMatcher(), new StackCreateComplete.IsCREATE_FAILEDMatcher(), new StackCreateComplete.IsDELETE_COMPLETEMatcher(), new StackCreateComplete.IsDELETE_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_FAILEDMatcher(), new StackCreateComplete.IsROLLBACK_COMPLETEMatcher(), new StackCreateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackImportComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackImportComplete.IsIMPORT_COMPLETEMatcher(), new StackImportComplete.IsROLLBACK_COMPLETEMatcher(), new StackImportComplete.IsROLLBACK_FAILEDMatcher(), new StackImportComplete.IsIMPORT_ROLLBACK_IN_PROGRESSMatcher(), new StackImportComplete.IsIMPORT_ROLLBACK_FAILEDMatcher(), new StackImportComplete.IsIMPORT_ROLLBACK_COMPLETEMatcher(), new StackImportComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackUpdateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackUpdateComplete.IsUPDATE_COMPLETEMatcher(), new StackUpdateComplete.IsUPDATE_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackUpdateComplete.IsUPDATE_ROLLBACK_COMPLETEMatcher(), new StackUpdateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeChangeSetRequest> changeSetCreateComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeChangeSetFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ChangeSetCreateComplete.IsCREATE_COMPLETEMatcher(), new ChangeSetCreateComplete.IsFAILEDMatcher(), new ChangeSetCreateComplete.IsValidationErrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStacksRequest> stackDeleteComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeStacksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new StackDeleteComplete.IsDELETE_COMPLETEMatcher(), new StackDeleteComplete.IsValidationErrorMatcher(), new StackDeleteComplete.IsDELETE_FAILEDMatcher(), new StackDeleteComplete.IsCREATE_FAILEDMatcher(), new StackDeleteComplete.IsROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_IN_PROGRESSMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_FAILEDMatcher(), new StackDeleteComplete.IsUPDATE_ROLLBACK_COMPLETEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTypeRegistrationRequest> typeRegistrationComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTypeRegistrationFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TypeRegistrationComplete.IsCOMPLETEMatcher(), new TypeRegistrationComplete.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(120), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

