/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ChangeSetSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListChangeSetsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ChangeSetSummary> summaries;
    private String nextToken;

    public List<ChangeSetSummary> getSummaries() {
        if (this.summaries == null) {
            this.summaries = new SdkInternalList();
        }
        return this.summaries;
    }

    public void setSummaries(Collection<ChangeSetSummary> summaries) {
        if (summaries == null) {
            this.summaries = null;
            return;
        }
        this.summaries = new SdkInternalList(summaries);
    }

    public ListChangeSetsResult withSummaries(ChangeSetSummary ... summaries) {
        if (this.summaries == null) {
            this.setSummaries((Collection<ChangeSetSummary>)new SdkInternalList(summaries.length));
        }
        for (ChangeSetSummary ele : summaries) {
            this.summaries.add((Object)ele);
        }
        return this;
    }

    public ListChangeSetsResult withSummaries(Collection<ChangeSetSummary> summaries) {
        this.setSummaries(summaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListChangeSetsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSummaries() != null) {
            sb.append("Summaries: ").append(this.getSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsResult)) {
            return false;
        }
        ListChangeSetsResult other = (ListChangeSetsResult)obj;
        if (other.getSummaries() == null ^ this.getSummaries() == null) {
            return false;
        }
        if (other.getSummaries() != null && !other.getSummaries().equals(this.getSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSummaries() == null ? 0 : this.getSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListChangeSetsResult clone() {
        try {
            return (ListChangeSetsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

