/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.CreateStackInstancesRequest;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class CreateStackInstancesRequestMarshaller
implements Marshaller<Request<CreateStackInstancesRequest>, CreateStackInstancesRequest> {
    public Request<CreateStackInstancesRequest> marshall(CreateStackInstancesRequest createStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        SdkInternalList regionsList;
        SdkInternalList accountsList;
        if (createStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackInstancesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "CreateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackInstancesRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)createStackInstancesRequest.getStackSetName()));
        }
        if ((accountsList = (SdkInternalList)createStackInstancesRequest.getAccounts()).isEmpty() && !accountsList.isAutoConstruct()) {
            request.addParameter("Accounts", "");
        }
        if (!accountsList.isEmpty() || !accountsList.isAutoConstruct()) {
            int accountsListIndex = 1;
            for (Object accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if ((regionsList = (SdkInternalList)createStackInstancesRequest.getRegions()).isEmpty() && !regionsList.isAutoConstruct()) {
            request.addParameter("Regions", "");
        }
        if (!regionsList.isEmpty() || !regionsList.isAutoConstruct()) {
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        if ((operationPreferences = createStackInstancesRequest.getOperationPreferences()) != null) {
            SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
            if (regionOrderList.isEmpty() && !regionOrderList.isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!regionOrderList.isEmpty() || !regionOrderList.isAutoConstruct()) {
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.getMaxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)createStackInstancesRequest.getOperationId()));
        return request;
    }
}

