/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateStackInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackSetName;
    private SdkInternalList<String> accounts;
    private SdkInternalList<String> regions;
    private StackSetOperationPreferences operationPreferences;
    private String operationId;

    public void setStackSetName(String stackSetName) {
        this.stackSetName = stackSetName;
    }

    public String getStackSetName() {
        return this.stackSetName;
    }

    public CreateStackInstancesRequest withStackSetName(String stackSetName) {
        this.setStackSetName(stackSetName);
        return this;
    }

    public List<String> getAccounts() {
        if (this.accounts == null) {
            this.accounts = new SdkInternalList();
        }
        return this.accounts;
    }

    public void setAccounts(Collection<String> accounts) {
        if (accounts == null) {
            this.accounts = null;
            return;
        }
        this.accounts = new SdkInternalList(accounts);
    }

    public CreateStackInstancesRequest withAccounts(String ... accounts) {
        if (this.accounts == null) {
            this.setAccounts((Collection<String>)new SdkInternalList(accounts.length));
        }
        for (String ele : accounts) {
            this.accounts.add((Object)ele);
        }
        return this;
    }

    public CreateStackInstancesRequest withAccounts(Collection<String> accounts) {
        this.setAccounts(accounts);
        return this;
    }

    public List<String> getRegions() {
        if (this.regions == null) {
            this.regions = new SdkInternalList();
        }
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new SdkInternalList(regions);
    }

    public CreateStackInstancesRequest withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions((Collection<String>)new SdkInternalList(regions.length));
        }
        for (String ele : regions) {
            this.regions.add((Object)ele);
        }
        return this;
    }

    public CreateStackInstancesRequest withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public void setOperationPreferences(StackSetOperationPreferences operationPreferences) {
        this.operationPreferences = operationPreferences;
    }

    public StackSetOperationPreferences getOperationPreferences() {
        return this.operationPreferences;
    }

    public CreateStackInstancesRequest withOperationPreferences(StackSetOperationPreferences operationPreferences) {
        this.setOperationPreferences(operationPreferences);
        return this;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public CreateStackInstancesRequest withOperationId(String operationId) {
        this.setOperationId(operationId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackSetName() != null) {
            sb.append("StackSetName: ").append(this.getStackSetName()).append(",");
        }
        if (this.getAccounts() != null) {
            sb.append("Accounts: ").append(this.getAccounts()).append(",");
        }
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getOperationPreferences() != null) {
            sb.append("OperationPreferences: ").append(this.getOperationPreferences()).append(",");
        }
        if (this.getOperationId() != null) {
            sb.append("OperationId: ").append(this.getOperationId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackInstancesRequest)) {
            return false;
        }
        CreateStackInstancesRequest other = (CreateStackInstancesRequest)obj;
        if (other.getStackSetName() == null ^ this.getStackSetName() == null) {
            return false;
        }
        if (other.getStackSetName() != null && !other.getStackSetName().equals(this.getStackSetName())) {
            return false;
        }
        if (other.getAccounts() == null ^ this.getAccounts() == null) {
            return false;
        }
        if (other.getAccounts() != null && !other.getAccounts().equals(this.getAccounts())) {
            return false;
        }
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getOperationPreferences() == null ^ this.getOperationPreferences() == null) {
            return false;
        }
        if (other.getOperationPreferences() != null && !other.getOperationPreferences().equals(this.getOperationPreferences())) {
            return false;
        }
        if (other.getOperationId() == null ^ this.getOperationId() == null) {
            return false;
        }
        return other.getOperationId() == null || other.getOperationId().equals(this.getOperationId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackSetName() == null ? 0 : this.getStackSetName().hashCode());
        hashCode = 31 * hashCode + (this.getAccounts() == null ? 0 : this.getAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getOperationPreferences() == null ? 0 : this.getOperationPreferences().hashCode());
        hashCode = 31 * hashCode + (this.getOperationId() == null ? 0 : this.getOperationId().hashCode());
        return hashCode;
    }

    public CreateStackInstancesRequest clone() {
        return (CreateStackInstancesRequest)super.clone();
    }
}

