/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.PolicyAttachment;
import com.amazonaws.services.clouddirectory.model.transform.PolicyToPathMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolicyToPath
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private List<PolicyAttachment> policies;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public PolicyToPath withPath(String path) {
        this.setPath(path);
        return this;
    }

    public List<PolicyAttachment> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Collection<PolicyAttachment> policies) {
        if (policies == null) {
            this.policies = null;
            return;
        }
        this.policies = new ArrayList<PolicyAttachment>(policies);
    }

    public PolicyToPath withPolicies(PolicyAttachment ... policies) {
        if (this.policies == null) {
            this.setPolicies(new ArrayList<PolicyAttachment>(policies.length));
        }
        for (PolicyAttachment ele : policies) {
            this.policies.add(ele);
        }
        return this;
    }

    public PolicyToPath withPolicies(Collection<PolicyAttachment> policies) {
        this.setPolicies(policies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: ").append(this.getPolicies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyToPath)) {
            return false;
        }
        PolicyToPath other = (PolicyToPath)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        return other.getPolicies() == null || other.getPolicies().equals(this.getPolicies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        return hashCode;
    }

    public PolicyToPath clone() {
        try {
            return (PolicyToPath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyToPathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

