/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.GetObjectInformationRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetObjectInformationRequestMarshaller
implements Marshaller<Request<GetObjectInformationRequest>, GetObjectInformationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetObjectInformationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetObjectInformationRequest> marshall(GetObjectInformationRequest getObjectInformationRequest) {
        if (getObjectInformationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getObjectInformationRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (getObjectInformationRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)getObjectInformationRequest.getDirectoryArn()));
        }
        if (getObjectInformationRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString((String)getObjectInformationRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object/information";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getObjectInformationRequest.getObjectReference() != null) {
                jsonGenerator.writeFieldName("ObjectReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(getObjectInformationRequest.getObjectReference(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

