/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.Directory;

public class DirectoryJsonMarshaller {
    private static DirectoryJsonMarshaller instance;

    public void marshall(Directory directory, StructuredJsonGenerator jsonGenerator) {
        if (directory == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (directory.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(directory.getName());
            }
            if (directory.getDirectoryArn() != null) {
                jsonGenerator.writeFieldName("DirectoryArn").writeValue(directory.getDirectoryArn());
            }
            if (directory.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(directory.getState());
            }
            if (directory.getCreationDateTime() != null) {
                jsonGenerator.writeFieldName("CreationDateTime").writeValue(directory.getCreationDateTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryJsonMarshaller();
        }
        return instance;
    }
}

