/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.FacetAttribute;
import com.amazonaws.services.clouddirectory.model.transform.FacetAttributeDefinitionJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.FacetAttributeReferenceJsonMarshaller;

public class FacetAttributeJsonMarshaller {
    private static FacetAttributeJsonMarshaller instance;

    public void marshall(FacetAttribute facetAttribute, StructuredJsonGenerator jsonGenerator) {
        if (facetAttribute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (facetAttribute.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(facetAttribute.getName());
            }
            if (facetAttribute.getAttributeDefinition() != null) {
                jsonGenerator.writeFieldName("AttributeDefinition");
                FacetAttributeDefinitionJsonMarshaller.getInstance().marshall(facetAttribute.getAttributeDefinition(), jsonGenerator);
            }
            if (facetAttribute.getAttributeReference() != null) {
                jsonGenerator.writeFieldName("AttributeReference");
                FacetAttributeReferenceJsonMarshaller.getInstance().marshall(facetAttribute.getAttributeReference(), jsonGenerator);
            }
            if (facetAttribute.getRequiredBehavior() != null) {
                jsonGenerator.writeFieldName("RequiredBehavior").writeValue(facetAttribute.getRequiredBehavior());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FacetAttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FacetAttributeJsonMarshaller();
        }
        return instance;
    }
}

