/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudcontrolapi.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.cloudcontrolapi.AWSCloudControlApi;
import com.amazonaws.services.cloudcontrolapi.model.GetResourceRequestStatusRequest;
import com.amazonaws.services.cloudcontrolapi.waiters.GetResourceRequestStatusFunction;
import com.amazonaws.services.cloudcontrolapi.waiters.ResourceRequestSuccess;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSCloudControlApiWaiters {
    private final AWSCloudControlApi client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSCloudControlApiWaiters");

    @SdkInternalApi
    public AWSCloudControlApiWaiters(AWSCloudControlApi client) {
        this.client = client;
    }

    public Waiter<GetResourceRequestStatusRequest> resourceRequestSuccess() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetResourceRequestStatusFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ResourceRequestSuccess.IsSUCCESSMatcher(), new ResourceRequestSuccess.IsFAILEDMatcher(), new ResourceRequestSuccess.IsCANCEL_COMPLETEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(24), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

