/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanroomsml.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cleanroomsml.model.S3ConfigMap;

@SdkInternalApi
public class S3ConfigMapMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Uri").build();
    private static final S3ConfigMapMarshaller instance = new S3ConfigMapMarshaller();

    public static S3ConfigMapMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ConfigMap s3ConfigMap, ProtocolMarshaller protocolMarshaller) {
        if (s3ConfigMap == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ConfigMap.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

