/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.ConfiguredTable;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ConfiguredTableMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<StructuredPojo> TABLEREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tableReference").build();
    private static final MarshallingInfo<Date> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> ANALYSISRULETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("analysisRuleTypes").build();
    private static final MarshallingInfo<String> ANALYSISMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("analysisMethod").build();
    private static final MarshallingInfo<List> ALLOWEDCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedColumns").build();
    private static final ConfiguredTableMarshaller instance = new ConfiguredTableMarshaller();

    public static ConfiguredTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfiguredTable configuredTable, ProtocolMarshaller protocolMarshaller) {
        if (configuredTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configuredTable.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getTableReference(), TABLEREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getUpdateTime(), UPDATETIME_BINDING);
            protocolMarshaller.marshall(configuredTable.getAnalysisRuleTypes(), ANALYSISRULETYPES_BINDING);
            protocolMarshaller.marshall((Object)configuredTable.getAnalysisMethod(), ANALYSISMETHOD_BINDING);
            protocolMarshaller.marshall(configuredTable.getAllowedColumns(), ALLOWEDCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

