/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cleanrooms.model.Schema;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SchemaMarshaller {
    private static final MarshallingInfo<List> COLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("columns").build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partitionKeys").build();
    private static final MarshallingInfo<List> ANALYSISRULETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("analysisRuleTypes").build();
    private static final MarshallingInfo<String> ANALYSISMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("analysisMethod").build();
    private static final MarshallingInfo<String> CREATORACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creatorAccountId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> COLLABORATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("collaborationId").build();
    private static final MarshallingInfo<String> COLLABORATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("collaborationArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Date> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> UPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<List> SCHEMASTATUSDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schemaStatusDetails").build();
    private static final SchemaMarshaller instance = new SchemaMarshaller();

    public static SchemaMarshaller getInstance() {
        return instance;
    }

    public void marshall(Schema schema, ProtocolMarshaller protocolMarshaller) {
        if (schema == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(schema.getColumns(), COLUMNS_BINDING);
            protocolMarshaller.marshall(schema.getPartitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall(schema.getAnalysisRuleTypes(), ANALYSISRULETYPES_BINDING);
            protocolMarshaller.marshall((Object)schema.getAnalysisMethod(), ANALYSISMETHOD_BINDING);
            protocolMarshaller.marshall((Object)schema.getCreatorAccountId(), CREATORACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)schema.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)schema.getCollaborationId(), COLLABORATIONID_BINDING);
            protocolMarshaller.marshall((Object)schema.getCollaborationArn(), COLLABORATIONARN_BINDING);
            protocolMarshaller.marshall((Object)schema.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)schema.getCreateTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall((Object)schema.getUpdateTime(), UPDATETIME_BINDING);
            protocolMarshaller.marshall((Object)schema.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(schema.getSchemaStatusDetails(), SCHEMASTATUSDETAILS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

