/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.AnalysisMethod;
import com.amazonaws.services.cleanrooms.model.AnalysisRuleType;
import com.amazonaws.services.cleanrooms.model.Column;
import com.amazonaws.services.cleanrooms.model.SchemaStatusDetail;
import com.amazonaws.services.cleanrooms.model.SchemaType;
import com.amazonaws.services.cleanrooms.model.transform.SchemaMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Schema
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Column> columns;
    private List<Column> partitionKeys;
    private List<String> analysisRuleTypes;
    private String analysisMethod;
    private String creatorAccountId;
    private String name;
    private String collaborationId;
    private String collaborationArn;
    private String description;
    private Date createTime;
    private Date updateTime;
    private String type;
    private List<SchemaStatusDetail> schemaStatusDetails;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<Column> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<Column>(columns);
    }

    public Schema withColumns(Column ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<Column>(columns.length));
        }
        for (Column ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public Schema withColumns(Collection<Column> columns) {
        this.setColumns(columns);
        return this;
    }

    public List<Column> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<Column> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        this.partitionKeys = new ArrayList<Column>(partitionKeys);
    }

    public Schema withPartitionKeys(Column ... partitionKeys) {
        if (this.partitionKeys == null) {
            this.setPartitionKeys(new ArrayList<Column>(partitionKeys.length));
        }
        for (Column ele : partitionKeys) {
            this.partitionKeys.add(ele);
        }
        return this;
    }

    public Schema withPartitionKeys(Collection<Column> partitionKeys) {
        this.setPartitionKeys(partitionKeys);
        return this;
    }

    public List<String> getAnalysisRuleTypes() {
        return this.analysisRuleTypes;
    }

    public void setAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
        if (analysisRuleTypes == null) {
            this.analysisRuleTypes = null;
            return;
        }
        this.analysisRuleTypes = new ArrayList<String>(analysisRuleTypes);
    }

    public Schema withAnalysisRuleTypes(String ... analysisRuleTypes) {
        if (this.analysisRuleTypes == null) {
            this.setAnalysisRuleTypes(new ArrayList<String>(analysisRuleTypes.length));
        }
        for (String ele : analysisRuleTypes) {
            this.analysisRuleTypes.add(ele);
        }
        return this;
    }

    public Schema withAnalysisRuleTypes(Collection<String> analysisRuleTypes) {
        this.setAnalysisRuleTypes(analysisRuleTypes);
        return this;
    }

    public Schema withAnalysisRuleTypes(AnalysisRuleType ... analysisRuleTypes) {
        ArrayList<String> analysisRuleTypesCopy = new ArrayList<String>(analysisRuleTypes.length);
        for (AnalysisRuleType value : analysisRuleTypes) {
            analysisRuleTypesCopy.add(value.toString());
        }
        if (this.getAnalysisRuleTypes() == null) {
            this.setAnalysisRuleTypes(analysisRuleTypesCopy);
        } else {
            this.getAnalysisRuleTypes().addAll(analysisRuleTypesCopy);
        }
        return this;
    }

    public void setAnalysisMethod(String analysisMethod) {
        this.analysisMethod = analysisMethod;
    }

    public String getAnalysisMethod() {
        return this.analysisMethod;
    }

    public Schema withAnalysisMethod(String analysisMethod) {
        this.setAnalysisMethod(analysisMethod);
        return this;
    }

    public Schema withAnalysisMethod(AnalysisMethod analysisMethod) {
        this.analysisMethod = analysisMethod.toString();
        return this;
    }

    public void setCreatorAccountId(String creatorAccountId) {
        this.creatorAccountId = creatorAccountId;
    }

    public String getCreatorAccountId() {
        return this.creatorAccountId;
    }

    public Schema withCreatorAccountId(String creatorAccountId) {
        this.setCreatorAccountId(creatorAccountId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Schema withName(String name) {
        this.setName(name);
        return this;
    }

    public void setCollaborationId(String collaborationId) {
        this.collaborationId = collaborationId;
    }

    public String getCollaborationId() {
        return this.collaborationId;
    }

    public Schema withCollaborationId(String collaborationId) {
        this.setCollaborationId(collaborationId);
        return this;
    }

    public void setCollaborationArn(String collaborationArn) {
        this.collaborationArn = collaborationArn;
    }

    public String getCollaborationArn() {
        return this.collaborationArn;
    }

    public Schema withCollaborationArn(String collaborationArn) {
        this.setCollaborationArn(collaborationArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Schema withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Schema withUpdateTime(Date updateTime) {
        this.setUpdateTime(updateTime);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Schema withType(String type) {
        this.setType(type);
        return this;
    }

    public Schema withType(SchemaType type) {
        this.type = type.toString();
        return this;
    }

    public List<SchemaStatusDetail> getSchemaStatusDetails() {
        return this.schemaStatusDetails;
    }

    public void setSchemaStatusDetails(Collection<SchemaStatusDetail> schemaStatusDetails) {
        if (schemaStatusDetails == null) {
            this.schemaStatusDetails = null;
            return;
        }
        this.schemaStatusDetails = new ArrayList<SchemaStatusDetail>(schemaStatusDetails);
    }

    public Schema withSchemaStatusDetails(SchemaStatusDetail ... schemaStatusDetails) {
        if (this.schemaStatusDetails == null) {
            this.setSchemaStatusDetails(new ArrayList<SchemaStatusDetail>(schemaStatusDetails.length));
        }
        for (SchemaStatusDetail ele : schemaStatusDetails) {
            this.schemaStatusDetails.add(ele);
        }
        return this;
    }

    public Schema withSchemaStatusDetails(Collection<SchemaStatusDetail> schemaStatusDetails) {
        this.setSchemaStatusDetails(schemaStatusDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: ").append(this.getPartitionKeys()).append(",");
        }
        if (this.getAnalysisRuleTypes() != null) {
            sb.append("AnalysisRuleTypes: ").append(this.getAnalysisRuleTypes()).append(",");
        }
        if (this.getAnalysisMethod() != null) {
            sb.append("AnalysisMethod: ").append(this.getAnalysisMethod()).append(",");
        }
        if (this.getCreatorAccountId() != null) {
            sb.append("CreatorAccountId: ").append(this.getCreatorAccountId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCollaborationId() != null) {
            sb.append("CollaborationId: ").append(this.getCollaborationId()).append(",");
        }
        if (this.getCollaborationArn() != null) {
            sb.append("CollaborationArn: ").append(this.getCollaborationArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getUpdateTime() != null) {
            sb.append("UpdateTime: ").append(this.getUpdateTime()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSchemaStatusDetails() != null) {
            sb.append("SchemaStatusDetails: ").append(this.getSchemaStatusDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)obj;
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getAnalysisRuleTypes() == null ^ this.getAnalysisRuleTypes() == null) {
            return false;
        }
        if (other.getAnalysisRuleTypes() != null && !other.getAnalysisRuleTypes().equals(this.getAnalysisRuleTypes())) {
            return false;
        }
        if (other.getAnalysisMethod() == null ^ this.getAnalysisMethod() == null) {
            return false;
        }
        if (other.getAnalysisMethod() != null && !other.getAnalysisMethod().equals(this.getAnalysisMethod())) {
            return false;
        }
        if (other.getCreatorAccountId() == null ^ this.getCreatorAccountId() == null) {
            return false;
        }
        if (other.getCreatorAccountId() != null && !other.getCreatorAccountId().equals(this.getCreatorAccountId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCollaborationId() == null ^ this.getCollaborationId() == null) {
            return false;
        }
        if (other.getCollaborationId() != null && !other.getCollaborationId().equals(this.getCollaborationId())) {
            return false;
        }
        if (other.getCollaborationArn() == null ^ this.getCollaborationArn() == null) {
            return false;
        }
        if (other.getCollaborationArn() != null && !other.getCollaborationArn().equals(this.getCollaborationArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null) {
            return false;
        }
        if (other.getUpdateTime() != null && !other.getUpdateTime().equals(this.getUpdateTime())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSchemaStatusDetails() == null ^ this.getSchemaStatusDetails() == null) {
            return false;
        }
        return other.getSchemaStatusDetails() == null || other.getSchemaStatusDetails().equals(this.getSchemaStatusDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisRuleTypes() == null ? 0 : this.getAnalysisRuleTypes().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisMethod() == null ? 0 : this.getAnalysisMethod().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorAccountId() == null ? 0 : this.getCreatorAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCollaborationId() == null ? 0 : this.getCollaborationId().hashCode());
        hashCode = 31 * hashCode + (this.getCollaborationArn() == null ? 0 : this.getCollaborationArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateTime() == null ? 0 : this.getUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaStatusDetails() == null ? 0 : this.getSchemaStatusDetails().hashCode());
        return hashCode;
    }

    public Schema clone() {
        try {
            return (Schema)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

