/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.AggregateColumn;
import com.amazonaws.services.cleanrooms.model.AggregationConstraint;
import com.amazonaws.services.cleanrooms.model.JoinOperator;
import com.amazonaws.services.cleanrooms.model.JoinRequiredOption;
import com.amazonaws.services.cleanrooms.model.ScalarFunctions;
import com.amazonaws.services.cleanrooms.model.transform.AnalysisRuleAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalysisRuleAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AggregateColumn> aggregateColumns;
    private List<String> joinColumns;
    private String joinRequired;
    private List<String> allowedJoinOperators;
    private List<String> dimensionColumns;
    private List<String> scalarFunctions;
    private List<AggregationConstraint> outputConstraints;

    public List<AggregateColumn> getAggregateColumns() {
        return this.aggregateColumns;
    }

    public void setAggregateColumns(Collection<AggregateColumn> aggregateColumns) {
        if (aggregateColumns == null) {
            this.aggregateColumns = null;
            return;
        }
        this.aggregateColumns = new ArrayList<AggregateColumn>(aggregateColumns);
    }

    public AnalysisRuleAggregation withAggregateColumns(AggregateColumn ... aggregateColumns) {
        if (this.aggregateColumns == null) {
            this.setAggregateColumns(new ArrayList<AggregateColumn>(aggregateColumns.length));
        }
        for (AggregateColumn ele : aggregateColumns) {
            this.aggregateColumns.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withAggregateColumns(Collection<AggregateColumn> aggregateColumns) {
        this.setAggregateColumns(aggregateColumns);
        return this;
    }

    public List<String> getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(Collection<String> joinColumns) {
        if (joinColumns == null) {
            this.joinColumns = null;
            return;
        }
        this.joinColumns = new ArrayList<String>(joinColumns);
    }

    public AnalysisRuleAggregation withJoinColumns(String ... joinColumns) {
        if (this.joinColumns == null) {
            this.setJoinColumns(new ArrayList<String>(joinColumns.length));
        }
        for (String ele : joinColumns) {
            this.joinColumns.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withJoinColumns(Collection<String> joinColumns) {
        this.setJoinColumns(joinColumns);
        return this;
    }

    public void setJoinRequired(String joinRequired) {
        this.joinRequired = joinRequired;
    }

    public String getJoinRequired() {
        return this.joinRequired;
    }

    public AnalysisRuleAggregation withJoinRequired(String joinRequired) {
        this.setJoinRequired(joinRequired);
        return this;
    }

    public AnalysisRuleAggregation withJoinRequired(JoinRequiredOption joinRequired) {
        this.joinRequired = joinRequired.toString();
        return this;
    }

    public List<String> getAllowedJoinOperators() {
        return this.allowedJoinOperators;
    }

    public void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
        if (allowedJoinOperators == null) {
            this.allowedJoinOperators = null;
            return;
        }
        this.allowedJoinOperators = new ArrayList<String>(allowedJoinOperators);
    }

    public AnalysisRuleAggregation withAllowedJoinOperators(String ... allowedJoinOperators) {
        if (this.allowedJoinOperators == null) {
            this.setAllowedJoinOperators(new ArrayList<String>(allowedJoinOperators.length));
        }
        for (String ele : allowedJoinOperators) {
            this.allowedJoinOperators.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withAllowedJoinOperators(Collection<String> allowedJoinOperators) {
        this.setAllowedJoinOperators(allowedJoinOperators);
        return this;
    }

    public AnalysisRuleAggregation withAllowedJoinOperators(JoinOperator ... allowedJoinOperators) {
        ArrayList<String> allowedJoinOperatorsCopy = new ArrayList<String>(allowedJoinOperators.length);
        for (JoinOperator value : allowedJoinOperators) {
            allowedJoinOperatorsCopy.add(value.toString());
        }
        if (this.getAllowedJoinOperators() == null) {
            this.setAllowedJoinOperators(allowedJoinOperatorsCopy);
        } else {
            this.getAllowedJoinOperators().addAll(allowedJoinOperatorsCopy);
        }
        return this;
    }

    public List<String> getDimensionColumns() {
        return this.dimensionColumns;
    }

    public void setDimensionColumns(Collection<String> dimensionColumns) {
        if (dimensionColumns == null) {
            this.dimensionColumns = null;
            return;
        }
        this.dimensionColumns = new ArrayList<String>(dimensionColumns);
    }

    public AnalysisRuleAggregation withDimensionColumns(String ... dimensionColumns) {
        if (this.dimensionColumns == null) {
            this.setDimensionColumns(new ArrayList<String>(dimensionColumns.length));
        }
        for (String ele : dimensionColumns) {
            this.dimensionColumns.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withDimensionColumns(Collection<String> dimensionColumns) {
        this.setDimensionColumns(dimensionColumns);
        return this;
    }

    public List<String> getScalarFunctions() {
        return this.scalarFunctions;
    }

    public void setScalarFunctions(Collection<String> scalarFunctions) {
        if (scalarFunctions == null) {
            this.scalarFunctions = null;
            return;
        }
        this.scalarFunctions = new ArrayList<String>(scalarFunctions);
    }

    public AnalysisRuleAggregation withScalarFunctions(String ... scalarFunctions) {
        if (this.scalarFunctions == null) {
            this.setScalarFunctions(new ArrayList<String>(scalarFunctions.length));
        }
        for (String ele : scalarFunctions) {
            this.scalarFunctions.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withScalarFunctions(Collection<String> scalarFunctions) {
        this.setScalarFunctions(scalarFunctions);
        return this;
    }

    public AnalysisRuleAggregation withScalarFunctions(ScalarFunctions ... scalarFunctions) {
        ArrayList<String> scalarFunctionsCopy = new ArrayList<String>(scalarFunctions.length);
        for (ScalarFunctions value : scalarFunctions) {
            scalarFunctionsCopy.add(value.toString());
        }
        if (this.getScalarFunctions() == null) {
            this.setScalarFunctions(scalarFunctionsCopy);
        } else {
            this.getScalarFunctions().addAll(scalarFunctionsCopy);
        }
        return this;
    }

    public List<AggregationConstraint> getOutputConstraints() {
        return this.outputConstraints;
    }

    public void setOutputConstraints(Collection<AggregationConstraint> outputConstraints) {
        if (outputConstraints == null) {
            this.outputConstraints = null;
            return;
        }
        this.outputConstraints = new ArrayList<AggregationConstraint>(outputConstraints);
    }

    public AnalysisRuleAggregation withOutputConstraints(AggregationConstraint ... outputConstraints) {
        if (this.outputConstraints == null) {
            this.setOutputConstraints(new ArrayList<AggregationConstraint>(outputConstraints.length));
        }
        for (AggregationConstraint ele : outputConstraints) {
            this.outputConstraints.add(ele);
        }
        return this;
    }

    public AnalysisRuleAggregation withOutputConstraints(Collection<AggregationConstraint> outputConstraints) {
        this.setOutputConstraints(outputConstraints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregateColumns() != null) {
            sb.append("AggregateColumns: ").append(this.getAggregateColumns()).append(",");
        }
        if (this.getJoinColumns() != null) {
            sb.append("JoinColumns: ").append(this.getJoinColumns()).append(",");
        }
        if (this.getJoinRequired() != null) {
            sb.append("JoinRequired: ").append(this.getJoinRequired()).append(",");
        }
        if (this.getAllowedJoinOperators() != null) {
            sb.append("AllowedJoinOperators: ").append(this.getAllowedJoinOperators()).append(",");
        }
        if (this.getDimensionColumns() != null) {
            sb.append("DimensionColumns: ").append(this.getDimensionColumns()).append(",");
        }
        if (this.getScalarFunctions() != null) {
            sb.append("ScalarFunctions: ").append(this.getScalarFunctions()).append(",");
        }
        if (this.getOutputConstraints() != null) {
            sb.append("OutputConstraints: ").append(this.getOutputConstraints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleAggregation)) {
            return false;
        }
        AnalysisRuleAggregation other = (AnalysisRuleAggregation)obj;
        if (other.getAggregateColumns() == null ^ this.getAggregateColumns() == null) {
            return false;
        }
        if (other.getAggregateColumns() != null && !other.getAggregateColumns().equals(this.getAggregateColumns())) {
            return false;
        }
        if (other.getJoinColumns() == null ^ this.getJoinColumns() == null) {
            return false;
        }
        if (other.getJoinColumns() != null && !other.getJoinColumns().equals(this.getJoinColumns())) {
            return false;
        }
        if (other.getJoinRequired() == null ^ this.getJoinRequired() == null) {
            return false;
        }
        if (other.getJoinRequired() != null && !other.getJoinRequired().equals(this.getJoinRequired())) {
            return false;
        }
        if (other.getAllowedJoinOperators() == null ^ this.getAllowedJoinOperators() == null) {
            return false;
        }
        if (other.getAllowedJoinOperators() != null && !other.getAllowedJoinOperators().equals(this.getAllowedJoinOperators())) {
            return false;
        }
        if (other.getDimensionColumns() == null ^ this.getDimensionColumns() == null) {
            return false;
        }
        if (other.getDimensionColumns() != null && !other.getDimensionColumns().equals(this.getDimensionColumns())) {
            return false;
        }
        if (other.getScalarFunctions() == null ^ this.getScalarFunctions() == null) {
            return false;
        }
        if (other.getScalarFunctions() != null && !other.getScalarFunctions().equals(this.getScalarFunctions())) {
            return false;
        }
        if (other.getOutputConstraints() == null ^ this.getOutputConstraints() == null) {
            return false;
        }
        return other.getOutputConstraints() == null || other.getOutputConstraints().equals(this.getOutputConstraints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregateColumns() == null ? 0 : this.getAggregateColumns().hashCode());
        hashCode = 31 * hashCode + (this.getJoinColumns() == null ? 0 : this.getJoinColumns().hashCode());
        hashCode = 31 * hashCode + (this.getJoinRequired() == null ? 0 : this.getJoinRequired().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedJoinOperators() == null ? 0 : this.getAllowedJoinOperators().hashCode());
        hashCode = 31 * hashCode + (this.getDimensionColumns() == null ? 0 : this.getDimensionColumns().hashCode());
        hashCode = 31 * hashCode + (this.getScalarFunctions() == null ? 0 : this.getScalarFunctions().hashCode());
        hashCode = 31 * hashCode + (this.getOutputConstraints() == null ? 0 : this.getOutputConstraints().hashCode());
        return hashCode;
    }

    public AnalysisRuleAggregation clone() {
        try {
            return (AnalysisRuleAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisRuleAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

