/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkvoice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkvoice.model.Capability;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateProxySessionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String voiceConnectorId;
    private String proxySessionId;
    private List<String> capabilities;
    private Integer expiryMinutes;

    public void setVoiceConnectorId(String voiceConnectorId) {
        this.voiceConnectorId = voiceConnectorId;
    }

    public String getVoiceConnectorId() {
        return this.voiceConnectorId;
    }

    public UpdateProxySessionRequest withVoiceConnectorId(String voiceConnectorId) {
        this.setVoiceConnectorId(voiceConnectorId);
        return this;
    }

    public void setProxySessionId(String proxySessionId) {
        this.proxySessionId = proxySessionId;
    }

    public String getProxySessionId() {
        return this.proxySessionId;
    }

    public UpdateProxySessionRequest withProxySessionId(String proxySessionId) {
        this.setProxySessionId(proxySessionId);
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public UpdateProxySessionRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public UpdateProxySessionRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public UpdateProxySessionRequest withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public void setExpiryMinutes(Integer expiryMinutes) {
        this.expiryMinutes = expiryMinutes;
    }

    public Integer getExpiryMinutes() {
        return this.expiryMinutes;
    }

    public UpdateProxySessionRequest withExpiryMinutes(Integer expiryMinutes) {
        this.setExpiryMinutes(expiryMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVoiceConnectorId() != null) {
            sb.append("VoiceConnectorId: ").append(this.getVoiceConnectorId()).append(",");
        }
        if (this.getProxySessionId() != null) {
            sb.append("ProxySessionId: ").append(this.getProxySessionId()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getExpiryMinutes() != null) {
            sb.append("ExpiryMinutes: ").append(this.getExpiryMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProxySessionRequest)) {
            return false;
        }
        UpdateProxySessionRequest other = (UpdateProxySessionRequest)obj;
        if (other.getVoiceConnectorId() == null ^ this.getVoiceConnectorId() == null) {
            return false;
        }
        if (other.getVoiceConnectorId() != null && !other.getVoiceConnectorId().equals(this.getVoiceConnectorId())) {
            return false;
        }
        if (other.getProxySessionId() == null ^ this.getProxySessionId() == null) {
            return false;
        }
        if (other.getProxySessionId() != null && !other.getProxySessionId().equals(this.getProxySessionId())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getExpiryMinutes() == null ^ this.getExpiryMinutes() == null) {
            return false;
        }
        return other.getExpiryMinutes() == null || other.getExpiryMinutes().equals(this.getExpiryMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVoiceConnectorId() == null ? 0 : this.getVoiceConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getProxySessionId() == null ? 0 : this.getProxySessionId().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getExpiryMinutes() == null ? 0 : this.getExpiryMinutes().hashCode());
        return hashCode;
    }

    public UpdateProxySessionRequest clone() {
        return (UpdateProxySessionRequest)super.clone();
    }
}

