/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkmessaging.model.ChannelMode;
import com.amazonaws.services.chimesdkmessaging.model.ChannelPrivacy;
import com.amazonaws.services.chimesdkmessaging.model.ElasticChannelConfiguration;
import com.amazonaws.services.chimesdkmessaging.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appInstanceArn;
    private String name;
    private String mode;
    private String privacy;
    private String metadata;
    private String clientRequestToken;
    private List<Tag> tags;
    private String chimeBearer;
    private String channelId;
    private List<String> memberArns;
    private List<String> moderatorArns;
    private ElasticChannelConfiguration elasticChannelConfiguration;

    public void setAppInstanceArn(String appInstanceArn) {
        this.appInstanceArn = appInstanceArn;
    }

    public String getAppInstanceArn() {
        return this.appInstanceArn;
    }

    public CreateChannelRequest withAppInstanceArn(String appInstanceArn) {
        this.setAppInstanceArn(appInstanceArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateChannelRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public CreateChannelRequest withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public CreateChannelRequest withMode(ChannelMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setPrivacy(String privacy) {
        this.privacy = privacy;
    }

    public String getPrivacy() {
        return this.privacy;
    }

    public CreateChannelRequest withPrivacy(String privacy) {
        this.setPrivacy(privacy);
        return this;
    }

    public CreateChannelRequest withPrivacy(ChannelPrivacy privacy) {
        this.privacy = privacy.toString();
        return this;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public CreateChannelRequest withMetadata(String metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateChannelRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateChannelRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setChimeBearer(String chimeBearer) {
        this.chimeBearer = chimeBearer;
    }

    public String getChimeBearer() {
        return this.chimeBearer;
    }

    public CreateChannelRequest withChimeBearer(String chimeBearer) {
        this.setChimeBearer(chimeBearer);
        return this;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public CreateChannelRequest withChannelId(String channelId) {
        this.setChannelId(channelId);
        return this;
    }

    public List<String> getMemberArns() {
        return this.memberArns;
    }

    public void setMemberArns(Collection<String> memberArns) {
        if (memberArns == null) {
            this.memberArns = null;
            return;
        }
        this.memberArns = new ArrayList<String>(memberArns);
    }

    public CreateChannelRequest withMemberArns(String ... memberArns) {
        if (this.memberArns == null) {
            this.setMemberArns(new ArrayList<String>(memberArns.length));
        }
        for (String ele : memberArns) {
            this.memberArns.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withMemberArns(Collection<String> memberArns) {
        this.setMemberArns(memberArns);
        return this;
    }

    public List<String> getModeratorArns() {
        return this.moderatorArns;
    }

    public void setModeratorArns(Collection<String> moderatorArns) {
        if (moderatorArns == null) {
            this.moderatorArns = null;
            return;
        }
        this.moderatorArns = new ArrayList<String>(moderatorArns);
    }

    public CreateChannelRequest withModeratorArns(String ... moderatorArns) {
        if (this.moderatorArns == null) {
            this.setModeratorArns(new ArrayList<String>(moderatorArns.length));
        }
        for (String ele : moderatorArns) {
            this.moderatorArns.add(ele);
        }
        return this;
    }

    public CreateChannelRequest withModeratorArns(Collection<String> moderatorArns) {
        this.setModeratorArns(moderatorArns);
        return this;
    }

    public void setElasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
        this.elasticChannelConfiguration = elasticChannelConfiguration;
    }

    public ElasticChannelConfiguration getElasticChannelConfiguration() {
        return this.elasticChannelConfiguration;
    }

    public CreateChannelRequest withElasticChannelConfiguration(ElasticChannelConfiguration elasticChannelConfiguration) {
        this.setElasticChannelConfiguration(elasticChannelConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppInstanceArn() != null) {
            sb.append("AppInstanceArn: ").append(this.getAppInstanceArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getPrivacy() != null) {
            sb.append("Privacy: ").append(this.getPrivacy()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getChimeBearer() != null) {
            sb.append("ChimeBearer: ").append(this.getChimeBearer()).append(",");
        }
        if (this.getChannelId() != null) {
            sb.append("ChannelId: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMemberArns() != null) {
            sb.append("MemberArns: ").append(this.getMemberArns()).append(",");
        }
        if (this.getModeratorArns() != null) {
            sb.append("ModeratorArns: ").append(this.getModeratorArns()).append(",");
        }
        if (this.getElasticChannelConfiguration() != null) {
            sb.append("ElasticChannelConfiguration: ").append(this.getElasticChannelConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)obj;
        if (other.getAppInstanceArn() == null ^ this.getAppInstanceArn() == null) {
            return false;
        }
        if (other.getAppInstanceArn() != null && !other.getAppInstanceArn().equals(this.getAppInstanceArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getPrivacy() == null ^ this.getPrivacy() == null) {
            return false;
        }
        if (other.getPrivacy() != null && !other.getPrivacy().equals(this.getPrivacy())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getChimeBearer() == null ^ this.getChimeBearer() == null) {
            return false;
        }
        if (other.getChimeBearer() != null && !other.getChimeBearer().equals(this.getChimeBearer())) {
            return false;
        }
        if (other.getChannelId() == null ^ this.getChannelId() == null) {
            return false;
        }
        if (other.getChannelId() != null && !other.getChannelId().equals(this.getChannelId())) {
            return false;
        }
        if (other.getMemberArns() == null ^ this.getMemberArns() == null) {
            return false;
        }
        if (other.getMemberArns() != null && !other.getMemberArns().equals(this.getMemberArns())) {
            return false;
        }
        if (other.getModeratorArns() == null ^ this.getModeratorArns() == null) {
            return false;
        }
        if (other.getModeratorArns() != null && !other.getModeratorArns().equals(this.getModeratorArns())) {
            return false;
        }
        if (other.getElasticChannelConfiguration() == null ^ this.getElasticChannelConfiguration() == null) {
            return false;
        }
        return other.getElasticChannelConfiguration() == null || other.getElasticChannelConfiguration().equals(this.getElasticChannelConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppInstanceArn() == null ? 0 : this.getAppInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getPrivacy() == null ? 0 : this.getPrivacy().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getChimeBearer() == null ? 0 : this.getChimeBearer().hashCode());
        hashCode = 31 * hashCode + (this.getChannelId() == null ? 0 : this.getChannelId().hashCode());
        hashCode = 31 * hashCode + (this.getMemberArns() == null ? 0 : this.getMemberArns().hashCode());
        hashCode = 31 * hashCode + (this.getModeratorArns() == null ? 0 : this.getModeratorArns().hashCode());
        hashCode = 31 * hashCode + (this.getElasticChannelConfiguration() == null ? 0 : this.getElasticChannelConfiguration().hashCode());
        return hashCode;
    }

    public CreateChannelRequest clone() {
        return (CreateChannelRequest)super.clone();
    }
}

