/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmeetings;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.chimesdkmeetings.AmazonChimeSDKMeetingsAsync;
import com.amazonaws.services.chimesdkmeetings.AmazonChimeSDKMeetingsAsyncClientBuilder;
import com.amazonaws.services.chimesdkmeetings.AmazonChimeSDKMeetingsClient;
import com.amazonaws.services.chimesdkmeetings.model.BatchCreateAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.BatchCreateAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResult;
import com.amazonaws.services.chimesdkmeetings.model.DeleteAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.DeleteAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.DeleteMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.DeleteMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.GetAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.GetAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.GetMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.GetMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.ListAttendeesRequest;
import com.amazonaws.services.chimesdkmeetings.model.ListAttendeesResult;
import com.amazonaws.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest;
import com.amazonaws.services.chimesdkmeetings.model.StartMeetingTranscriptionResult;
import com.amazonaws.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest;
import com.amazonaws.services.chimesdkmeetings.model.StopMeetingTranscriptionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonChimeSDKMeetingsAsyncClient
extends AmazonChimeSDKMeetingsClient
implements AmazonChimeSDKMeetingsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonChimeSDKMeetingsAsyncClientBuilder asyncBuilder() {
        return AmazonChimeSDKMeetingsAsyncClientBuilder.standard();
    }

    AmazonChimeSDKMeetingsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonChimeSDKMeetingsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCreateAttendeeResult> batchCreateAttendeeAsync(BatchCreateAttendeeRequest request) {
        return this.batchCreateAttendeeAsync(request, null);
    }

    @Override
    public Future<BatchCreateAttendeeResult> batchCreateAttendeeAsync(BatchCreateAttendeeRequest request, final AsyncHandler<BatchCreateAttendeeRequest, BatchCreateAttendeeResult> asyncHandler) {
        final BatchCreateAttendeeRequest finalRequest = (BatchCreateAttendeeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchCreateAttendeeResult>(){

            @Override
            public BatchCreateAttendeeResult call() throws Exception {
                BatchCreateAttendeeResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeBatchCreateAttendee(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAttendeeResult> createAttendeeAsync(CreateAttendeeRequest request) {
        return this.createAttendeeAsync(request, null);
    }

    @Override
    public Future<CreateAttendeeResult> createAttendeeAsync(CreateAttendeeRequest request, final AsyncHandler<CreateAttendeeRequest, CreateAttendeeResult> asyncHandler) {
        final CreateAttendeeRequest finalRequest = (CreateAttendeeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAttendeeResult>(){

            @Override
            public CreateAttendeeResult call() throws Exception {
                CreateAttendeeResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeCreateAttendee(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMeetingResult> createMeetingAsync(CreateMeetingRequest request) {
        return this.createMeetingAsync(request, null);
    }

    @Override
    public Future<CreateMeetingResult> createMeetingAsync(CreateMeetingRequest request, final AsyncHandler<CreateMeetingRequest, CreateMeetingResult> asyncHandler) {
        final CreateMeetingRequest finalRequest = (CreateMeetingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMeetingResult>(){

            @Override
            public CreateMeetingResult call() throws Exception {
                CreateMeetingResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeCreateMeeting(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMeetingWithAttendeesResult> createMeetingWithAttendeesAsync(CreateMeetingWithAttendeesRequest request) {
        return this.createMeetingWithAttendeesAsync(request, null);
    }

    @Override
    public Future<CreateMeetingWithAttendeesResult> createMeetingWithAttendeesAsync(CreateMeetingWithAttendeesRequest request, final AsyncHandler<CreateMeetingWithAttendeesRequest, CreateMeetingWithAttendeesResult> asyncHandler) {
        final CreateMeetingWithAttendeesRequest finalRequest = (CreateMeetingWithAttendeesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMeetingWithAttendeesResult>(){

            @Override
            public CreateMeetingWithAttendeesResult call() throws Exception {
                CreateMeetingWithAttendeesResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeCreateMeetingWithAttendees(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAttendeeResult> deleteAttendeeAsync(DeleteAttendeeRequest request) {
        return this.deleteAttendeeAsync(request, null);
    }

    @Override
    public Future<DeleteAttendeeResult> deleteAttendeeAsync(DeleteAttendeeRequest request, final AsyncHandler<DeleteAttendeeRequest, DeleteAttendeeResult> asyncHandler) {
        final DeleteAttendeeRequest finalRequest = (DeleteAttendeeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAttendeeResult>(){

            @Override
            public DeleteAttendeeResult call() throws Exception {
                DeleteAttendeeResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeDeleteAttendee(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMeetingResult> deleteMeetingAsync(DeleteMeetingRequest request) {
        return this.deleteMeetingAsync(request, null);
    }

    @Override
    public Future<DeleteMeetingResult> deleteMeetingAsync(DeleteMeetingRequest request, final AsyncHandler<DeleteMeetingRequest, DeleteMeetingResult> asyncHandler) {
        final DeleteMeetingRequest finalRequest = (DeleteMeetingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMeetingResult>(){

            @Override
            public DeleteMeetingResult call() throws Exception {
                DeleteMeetingResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeDeleteMeeting(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAttendeeResult> getAttendeeAsync(GetAttendeeRequest request) {
        return this.getAttendeeAsync(request, null);
    }

    @Override
    public Future<GetAttendeeResult> getAttendeeAsync(GetAttendeeRequest request, final AsyncHandler<GetAttendeeRequest, GetAttendeeResult> asyncHandler) {
        final GetAttendeeRequest finalRequest = (GetAttendeeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAttendeeResult>(){

            @Override
            public GetAttendeeResult call() throws Exception {
                GetAttendeeResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeGetAttendee(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMeetingResult> getMeetingAsync(GetMeetingRequest request) {
        return this.getMeetingAsync(request, null);
    }

    @Override
    public Future<GetMeetingResult> getMeetingAsync(GetMeetingRequest request, final AsyncHandler<GetMeetingRequest, GetMeetingResult> asyncHandler) {
        final GetMeetingRequest finalRequest = (GetMeetingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMeetingResult>(){

            @Override
            public GetMeetingResult call() throws Exception {
                GetMeetingResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeGetMeeting(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttendeesResult> listAttendeesAsync(ListAttendeesRequest request) {
        return this.listAttendeesAsync(request, null);
    }

    @Override
    public Future<ListAttendeesResult> listAttendeesAsync(ListAttendeesRequest request, final AsyncHandler<ListAttendeesRequest, ListAttendeesResult> asyncHandler) {
        final ListAttendeesRequest finalRequest = (ListAttendeesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAttendeesResult>(){

            @Override
            public ListAttendeesResult call() throws Exception {
                ListAttendeesResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeListAttendees(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMeetingTranscriptionResult> startMeetingTranscriptionAsync(StartMeetingTranscriptionRequest request) {
        return this.startMeetingTranscriptionAsync(request, null);
    }

    @Override
    public Future<StartMeetingTranscriptionResult> startMeetingTranscriptionAsync(StartMeetingTranscriptionRequest request, final AsyncHandler<StartMeetingTranscriptionRequest, StartMeetingTranscriptionResult> asyncHandler) {
        final StartMeetingTranscriptionRequest finalRequest = (StartMeetingTranscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMeetingTranscriptionResult>(){

            @Override
            public StartMeetingTranscriptionResult call() throws Exception {
                StartMeetingTranscriptionResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeStartMeetingTranscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopMeetingTranscriptionResult> stopMeetingTranscriptionAsync(StopMeetingTranscriptionRequest request) {
        return this.stopMeetingTranscriptionAsync(request, null);
    }

    @Override
    public Future<StopMeetingTranscriptionResult> stopMeetingTranscriptionAsync(StopMeetingTranscriptionRequest request, final AsyncHandler<StopMeetingTranscriptionRequest, StopMeetingTranscriptionResult> asyncHandler) {
        final StopMeetingTranscriptionRequest finalRequest = (StopMeetingTranscriptionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopMeetingTranscriptionResult>(){

            @Override
            public StopMeetingTranscriptionResult call() throws Exception {
                StopMeetingTranscriptionResult result = null;
                try {
                    result = AmazonChimeSDKMeetingsAsyncClient.this.executeStopMeetingTranscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

