/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.PhoneNumberCountry;
import java.util.List;

@SdkInternalApi
public class PhoneNumberCountryMarshaller {
    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountryCode").build();
    private static final MarshallingInfo<List> SUPPORTEDPHONENUMBERTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedPhoneNumberTypes").build();
    private static final PhoneNumberCountryMarshaller instance = new PhoneNumberCountryMarshaller();

    public static PhoneNumberCountryMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhoneNumberCountry phoneNumberCountry, ProtocolMarshaller protocolMarshaller) {
        if (phoneNumberCountry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)phoneNumberCountry.getCountryCode(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall(phoneNumberCountry.getSupportedPhoneNumberTypes(), SUPPORTEDPHONENUMBERTYPES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

