/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.chime.model.Attendee;
import com.amazonaws.services.chime.model.CreateAttendeeError;
import com.amazonaws.services.chime.model.Meeting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMeetingWithAttendeesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Meeting meeting;
    private List<Attendee> attendees;
    private List<CreateAttendeeError> errors;

    public void setMeeting(Meeting meeting) {
        this.meeting = meeting;
    }

    public Meeting getMeeting() {
        return this.meeting;
    }

    public CreateMeetingWithAttendeesResult withMeeting(Meeting meeting) {
        this.setMeeting(meeting);
        return this;
    }

    public List<Attendee> getAttendees() {
        return this.attendees;
    }

    public void setAttendees(Collection<Attendee> attendees) {
        if (attendees == null) {
            this.attendees = null;
            return;
        }
        this.attendees = new ArrayList<Attendee>(attendees);
    }

    public CreateMeetingWithAttendeesResult withAttendees(Attendee ... attendees) {
        if (this.attendees == null) {
            this.setAttendees(new ArrayList<Attendee>(attendees.length));
        }
        for (Attendee ele : attendees) {
            this.attendees.add(ele);
        }
        return this;
    }

    public CreateMeetingWithAttendeesResult withAttendees(Collection<Attendee> attendees) {
        this.setAttendees(attendees);
        return this;
    }

    public List<CreateAttendeeError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<CreateAttendeeError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<CreateAttendeeError>(errors);
    }

    public CreateMeetingWithAttendeesResult withErrors(CreateAttendeeError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<CreateAttendeeError>(errors.length));
        }
        for (CreateAttendeeError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public CreateMeetingWithAttendeesResult withErrors(Collection<CreateAttendeeError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMeeting() != null) {
            sb.append("Meeting: ").append(this.getMeeting()).append(",");
        }
        if (this.getAttendees() != null) {
            sb.append("Attendees: ").append(this.getAttendees()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesResult)) {
            return false;
        }
        CreateMeetingWithAttendeesResult other = (CreateMeetingWithAttendeesResult)obj;
        if (other.getMeeting() == null ^ this.getMeeting() == null) {
            return false;
        }
        if (other.getMeeting() != null && !other.getMeeting().equals(this.getMeeting())) {
            return false;
        }
        if (other.getAttendees() == null ^ this.getAttendees() == null) {
            return false;
        }
        if (other.getAttendees() != null && !other.getAttendees().equals(this.getAttendees())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMeeting() == null ? 0 : this.getMeeting().hashCode());
        hashCode = 31 * hashCode + (this.getAttendees() == null ? 0 : this.getAttendees().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public CreateMeetingWithAttendeesResult clone() {
        try {
            return (CreateMeetingWithAttendeesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

