/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.chime.AmazonChime;
import com.amazonaws.services.chime.AmazonChimeClientBuilder;
import com.amazonaws.services.chime.model.AmazonChimeException;
import com.amazonaws.services.chime.model.BadRequestException;
import com.amazonaws.services.chime.model.BatchSuspendUserRequest;
import com.amazonaws.services.chime.model.BatchSuspendUserResult;
import com.amazonaws.services.chime.model.BatchUnsuspendUserRequest;
import com.amazonaws.services.chime.model.BatchUnsuspendUserResult;
import com.amazonaws.services.chime.model.BatchUpdateUserRequest;
import com.amazonaws.services.chime.model.BatchUpdateUserResult;
import com.amazonaws.services.chime.model.ConflictException;
import com.amazonaws.services.chime.model.CreateAccountRequest;
import com.amazonaws.services.chime.model.CreateAccountResult;
import com.amazonaws.services.chime.model.DeleteAccountRequest;
import com.amazonaws.services.chime.model.DeleteAccountResult;
import com.amazonaws.services.chime.model.ForbiddenException;
import com.amazonaws.services.chime.model.GetAccountRequest;
import com.amazonaws.services.chime.model.GetAccountResult;
import com.amazonaws.services.chime.model.GetAccountSettingsRequest;
import com.amazonaws.services.chime.model.GetAccountSettingsResult;
import com.amazonaws.services.chime.model.GetUserRequest;
import com.amazonaws.services.chime.model.GetUserResult;
import com.amazonaws.services.chime.model.InviteUsersRequest;
import com.amazonaws.services.chime.model.InviteUsersResult;
import com.amazonaws.services.chime.model.ListAccountsRequest;
import com.amazonaws.services.chime.model.ListAccountsResult;
import com.amazonaws.services.chime.model.ListUsersRequest;
import com.amazonaws.services.chime.model.ListUsersResult;
import com.amazonaws.services.chime.model.LogoutUserRequest;
import com.amazonaws.services.chime.model.LogoutUserResult;
import com.amazonaws.services.chime.model.NotFoundException;
import com.amazonaws.services.chime.model.ResetPersonalPINRequest;
import com.amazonaws.services.chime.model.ResetPersonalPINResult;
import com.amazonaws.services.chime.model.ServiceFailureException;
import com.amazonaws.services.chime.model.ServiceUnavailableException;
import com.amazonaws.services.chime.model.ThrottledClientException;
import com.amazonaws.services.chime.model.UnauthorizedClientException;
import com.amazonaws.services.chime.model.UnprocessableEntityException;
import com.amazonaws.services.chime.model.UpdateAccountRequest;
import com.amazonaws.services.chime.model.UpdateAccountResult;
import com.amazonaws.services.chime.model.UpdateAccountSettingsRequest;
import com.amazonaws.services.chime.model.UpdateAccountSettingsResult;
import com.amazonaws.services.chime.model.UpdateUserRequest;
import com.amazonaws.services.chime.model.UpdateUserResult;
import com.amazonaws.services.chime.model.transform.BatchSuspendUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.BatchSuspendUserResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.BatchUnsuspendUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.BatchUnsuspendUserResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.BatchUpdateUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.BatchUpdateUserResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.CreateAccountRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.CreateAccountResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.DeleteAccountRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.DeleteAccountResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.GetAccountRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.GetAccountResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.GetAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.GetAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.GetUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.GetUserResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.InviteUsersRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.InviteUsersResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.ListAccountsRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.ListAccountsResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.ListUsersRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.ListUsersResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.LogoutUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.LogoutUserResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.ResetPersonalPINRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.ResetPersonalPINResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.UpdateAccountRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.UpdateAccountResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.UpdateAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.UpdateAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.chime.model.transform.UpdateUserRequestProtocolMarshaller;
import com.amazonaws.services.chime.model.transform.UpdateUserResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonChimeClient
extends AmazonWebServiceClient
implements AmazonChime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonChime.class);
    private static final String DEFAULT_SIGNING_NAME = "chime";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(ConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedClientException").withModeledClass(UnauthorizedClientException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withModeledClass(UnprocessableEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottledClientException").withModeledClass(ThrottledClientException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceFailureException").withModeledClass(ServiceFailureException.class)).withBaseServiceExceptionClass(AmazonChimeException.class));

    public static AmazonChimeClientBuilder builder() {
        return AmazonChimeClientBuilder.standard();
    }

    AmazonChimeClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    AmazonChimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("chime.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/chime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/chime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchSuspendUserResult batchSuspendUser(BatchSuspendUserRequest request) {
        request = (BatchSuspendUserRequest)this.beforeClientExecution(request);
        return this.executeBatchSuspendUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchSuspendUserResult executeBatchSuspendUser(BatchSuspendUserRequest batchSuspendUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchSuspendUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchSuspendUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchSuspendUserRequestProtocolMarshaller(protocolFactory).marshall((BatchSuspendUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchSuspendUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchSuspendUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchSuspendUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchSuspendUserResult batchSuspendUserResult = (BatchSuspendUserResult)response.getAwsResponse();
            return batchSuspendUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUnsuspendUserResult batchUnsuspendUser(BatchUnsuspendUserRequest request) {
        request = (BatchUnsuspendUserRequest)this.beforeClientExecution(request);
        return this.executeBatchUnsuspendUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUnsuspendUserResult executeBatchUnsuspendUser(BatchUnsuspendUserRequest batchUnsuspendUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUnsuspendUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUnsuspendUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUnsuspendUserRequestProtocolMarshaller(protocolFactory).marshall((BatchUnsuspendUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUnsuspendUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUnsuspendUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUnsuspendUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUnsuspendUserResult batchUnsuspendUserResult = (BatchUnsuspendUserResult)response.getAwsResponse();
            return batchUnsuspendUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchUpdateUserResult batchUpdateUser(BatchUpdateUserRequest request) {
        request = (BatchUpdateUserRequest)this.beforeClientExecution(request);
        return this.executeBatchUpdateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchUpdateUserResult executeBatchUpdateUser(BatchUpdateUserRequest batchUpdateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchUpdateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchUpdateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchUpdateUserRequestProtocolMarshaller(protocolFactory).marshall((BatchUpdateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchUpdateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchUpdateUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchUpdateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchUpdateUserResult batchUpdateUserResult = (BatchUpdateUserResult)response.getAwsResponse();
            return batchUpdateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAccountResult createAccount(CreateAccountRequest request) {
        request = (CreateAccountRequest)this.beforeClientExecution(request);
        return this.executeCreateAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAccountResult executeCreateAccount(CreateAccountRequest createAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAccountRequestProtocolMarshaller(protocolFactory).marshall((CreateAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAccount");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAccountResult createAccountResult = (CreateAccountResult)response.getAwsResponse();
            return createAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAccountResult deleteAccount(DeleteAccountRequest request) {
        request = (DeleteAccountRequest)this.beforeClientExecution(request);
        return this.executeDeleteAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAccountResult executeDeleteAccount(DeleteAccountRequest deleteAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAccountRequestProtocolMarshaller(protocolFactory).marshall((DeleteAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAccount");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAccountResult deleteAccountResult = (DeleteAccountResult)response.getAwsResponse();
            return deleteAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccountResult getAccount(GetAccountRequest request) {
        request = (GetAccountRequest)this.beforeClientExecution(request);
        return this.executeGetAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountResult executeGetAccount(GetAccountRequest getAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountRequestProtocolMarshaller(protocolFactory).marshall((GetAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccount");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountResult getAccountResult = (GetAccountResult)response.getAwsResponse();
            return getAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        request = (GetAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountSettingsResult executeGetAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccountSettings");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountSettingsResult getAccountSettingsResult = (GetAccountSettingsResult)response.getAwsResponse();
            return getAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetUserResult getUser(GetUserRequest request) {
        request = (GetUserRequest)this.beforeClientExecution(request);
        return this.executeGetUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetUserResult executeGetUser(GetUserRequest getUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetUserRequestProtocolMarshaller(protocolFactory).marshall((GetUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)getUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetUserResult getUserResult = (GetUserResult)response.getAwsResponse();
            return getUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public InviteUsersResult inviteUsers(InviteUsersRequest request) {
        request = (InviteUsersRequest)this.beforeClientExecution(request);
        return this.executeInviteUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final InviteUsersResult executeInviteUsers(InviteUsersRequest inviteUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(inviteUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InviteUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InviteUsersRequestProtocolMarshaller(protocolFactory).marshall((InviteUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)inviteUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"InviteUsers");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InviteUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InviteUsersResult inviteUsersResult = (InviteUsersResult)response.getAwsResponse();
            return inviteUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAccountsResult listAccounts(ListAccountsRequest request) {
        request = (ListAccountsRequest)this.beforeClientExecution(request);
        return this.executeListAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAccountsResult executeListAccounts(ListAccountsRequest listAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAccounts");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAccountsResult listAccountsResult = (ListAccountsResult)response.getAwsResponse();
            return listAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        request = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executeListUsers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListUsersResult executeListUsers(ListUsersRequest listUsersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListUsersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListUsersRequestProtocolMarshaller(protocolFactory).marshall((ListUsersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listUsersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListUsers");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListUsersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListUsersResult listUsersResult = (ListUsersResult)response.getAwsResponse();
            return listUsersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LogoutUserResult logoutUser(LogoutUserRequest request) {
        request = (LogoutUserRequest)this.beforeClientExecution(request);
        return this.executeLogoutUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final LogoutUserResult executeLogoutUser(LogoutUserRequest logoutUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(logoutUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LogoutUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LogoutUserRequestProtocolMarshaller(protocolFactory).marshall((LogoutUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)logoutUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"LogoutUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new LogoutUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            LogoutUserResult logoutUserResult = (LogoutUserResult)response.getAwsResponse();
            return logoutUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResetPersonalPINResult resetPersonalPIN(ResetPersonalPINRequest request) {
        request = (ResetPersonalPINRequest)this.beforeClientExecution(request);
        return this.executeResetPersonalPIN(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResetPersonalPINResult executeResetPersonalPIN(ResetPersonalPINRequest resetPersonalPINRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resetPersonalPINRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResetPersonalPINRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResetPersonalPINRequestProtocolMarshaller(protocolFactory).marshall((ResetPersonalPINRequest)super.beforeMarshalling((AmazonWebServiceRequest)resetPersonalPINRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResetPersonalPIN");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResetPersonalPINResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResetPersonalPINResult resetPersonalPINResult = (ResetPersonalPINResult)response.getAwsResponse();
            return resetPersonalPINResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAccountResult updateAccount(UpdateAccountRequest request) {
        request = (UpdateAccountRequest)this.beforeClientExecution(request);
        return this.executeUpdateAccount(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAccountResult executeUpdateAccount(UpdateAccountRequest updateAccountRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAccountRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAccountRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAccountRequestProtocolMarshaller(protocolFactory).marshall((UpdateAccountRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAccountRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAccount");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAccountResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAccountResult updateAccountResult = (UpdateAccountResult)response.getAwsResponse();
            return updateAccountResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        request = (UpdateAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executeUpdateAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAccountSettingsResult executeUpdateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((UpdateAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAccountSettings");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAccountSettingsResult updateAccountSettingsResult = (UpdateAccountSettingsResult)response.getAwsResponse();
            return updateAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        request = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executeUpdateUser(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateUserResult executeUpdateUser(UpdateUserRequest updateUserRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateUserRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateUserRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateUserRequestProtocolMarshaller(protocolFactory).marshall((UpdateUserRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateUserRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateUser");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            Object cachedEndpoint = null;
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateUserResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateUserResult updateUserResult = (UpdateUserResult)response.getAwsResponse();
            return updateUserResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

