/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.wellarchitected.model.Workload;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class WorkloadMarshaller {
    private static final MarshallingInfo<String> WORKLOADID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkloadId").build();
    private static final MarshallingInfo<String> WORKLOADARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkloadArn").build();
    private static final MarshallingInfo<String> WORKLOADNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkloadName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> ENVIRONMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final MarshallingInfo<Date> UPDATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> ACCOUNTIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIds").build();
    private static final MarshallingInfo<List> AWSREGIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AwsRegions").build();
    private static final MarshallingInfo<List> NONAWSREGIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonAwsRegions").build();
    private static final MarshallingInfo<String> ARCHITECTURALDESIGN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchitecturalDesign").build();
    private static final MarshallingInfo<String> REVIEWOWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewOwner").build();
    private static final MarshallingInfo<Date> REVIEWRESTRICTIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewRestrictionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> ISREVIEWOWNERUPDATEACKNOWLEDGED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsReviewOwnerUpdateAcknowledged").build();
    private static final MarshallingInfo<String> INDUSTRYTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndustryType").build();
    private static final MarshallingInfo<String> INDUSTRY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Industry").build();
    private static final MarshallingInfo<String> NOTES_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notes").build();
    private static final MarshallingInfo<String> IMPROVEMENTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImprovementStatus").build();
    private static final MarshallingInfo<Map> RISKCOUNTS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RiskCounts").build();
    private static final MarshallingInfo<List> PILLARPRIORITIES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PillarPriorities").build();
    private static final MarshallingInfo<List> LENSES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lenses").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> SHAREINVITATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShareInvitationId").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final WorkloadMarshaller instance = new WorkloadMarshaller();

    public static WorkloadMarshaller getInstance() {
        return instance;
    }

    public void marshall(Workload workload, ProtocolMarshaller protocolMarshaller) {
        if (workload == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(workload.getWorkloadId(), WORKLOADID_BINDING);
            protocolMarshaller.marshall(workload.getWorkloadArn(), WORKLOADARN_BINDING);
            protocolMarshaller.marshall(workload.getWorkloadName(), WORKLOADNAME_BINDING);
            protocolMarshaller.marshall(workload.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(workload.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall(workload.getUpdatedAt(), UPDATEDAT_BINDING);
            protocolMarshaller.marshall(workload.getAccountIds(), ACCOUNTIDS_BINDING);
            protocolMarshaller.marshall(workload.getAwsRegions(), AWSREGIONS_BINDING);
            protocolMarshaller.marshall(workload.getNonAwsRegions(), NONAWSREGIONS_BINDING);
            protocolMarshaller.marshall(workload.getArchitecturalDesign(), ARCHITECTURALDESIGN_BINDING);
            protocolMarshaller.marshall(workload.getReviewOwner(), REVIEWOWNER_BINDING);
            protocolMarshaller.marshall(workload.getReviewRestrictionDate(), REVIEWRESTRICTIONDATE_BINDING);
            protocolMarshaller.marshall(workload.getIsReviewOwnerUpdateAcknowledged(), ISREVIEWOWNERUPDATEACKNOWLEDGED_BINDING);
            protocolMarshaller.marshall(workload.getIndustryType(), INDUSTRYTYPE_BINDING);
            protocolMarshaller.marshall(workload.getIndustry(), INDUSTRY_BINDING);
            protocolMarshaller.marshall(workload.getNotes(), NOTES_BINDING);
            protocolMarshaller.marshall(workload.getImprovementStatus(), IMPROVEMENTSTATUS_BINDING);
            protocolMarshaller.marshall(workload.getRiskCounts(), RISKCOUNTS_BINDING);
            protocolMarshaller.marshall(workload.getPillarPriorities(), PILLARPRIORITIES_BINDING);
            protocolMarshaller.marshall(workload.getLenses(), LENSES_BINDING);
            protocolMarshaller.marshall(workload.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall(workload.getShareInvitationId(), SHAREINVITATIONID_BINDING);
            protocolMarshaller.marshall(workload.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

