/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.ResourcePolicy;

@SdkInternalApi
public class ResourcePolicyMarshaller {
    private static final MarshallingInfo<String> POLICYDOCUMENT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyDocument").build();
    private static final MarshallingInfo<String> POLICYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyId").build();
    private static final MarshallingInfo<String> RAMRESOURCESHAREREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ramResourceShareRegion").build();
    private static final ResourcePolicyMarshaller instance = new ResourcePolicyMarshaller();

    public static ResourcePolicyMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourcePolicy resourcePolicy, ProtocolMarshaller protocolMarshaller) {
        if (resourcePolicy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourcePolicy.getPolicyDocument(), POLICYDOCUMENT_BINDING);
            protocolMarshaller.marshall(resourcePolicy.getPolicyId(), POLICYID_BINDING);
            protocolMarshaller.marshall(resourcePolicy.getRamResourceShareRegion(), RAMRESOURCESHAREREGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

