/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.IncidentTemplate;
import java.util.List;

@SdkInternalApi
public class IncidentTemplateMarshaller {
    private static final MarshallingInfo<String> DEDUPESTRING_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dedupeString").build();
    private static final MarshallingInfo<Integer> IMPACT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("impact").build();
    private static final MarshallingInfo<List> NOTIFICATIONTARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("notificationTargets").build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("summary").build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("title").build();
    private static final IncidentTemplateMarshaller instance = new IncidentTemplateMarshaller();

    public static IncidentTemplateMarshaller getInstance() {
        return instance;
    }

    public void marshall(IncidentTemplate incidentTemplate, ProtocolMarshaller protocolMarshaller) {
        if (incidentTemplate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(incidentTemplate.getDedupeString(), DEDUPESTRING_BINDING);
            protocolMarshaller.marshall(incidentTemplate.getImpact(), IMPACT_BINDING);
            protocolMarshaller.marshall(incidentTemplate.getNotificationTargets(), NOTIFICATIONTARGETS_BINDING);
            protocolMarshaller.marshall(incidentTemplate.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall(incidentTemplate.getTitle(), TITLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

