/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.AttributeValueList;
import java.util.List;

@SdkInternalApi
public class AttributeValueListMarshaller {
    private static final MarshallingInfo<List> INTEGERVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("integerValues").build();
    private static final MarshallingInfo<List> STRINGVALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValues").build();
    private static final AttributeValueListMarshaller instance = new AttributeValueListMarshaller();

    public static AttributeValueListMarshaller getInstance() {
        return instance;
    }

    public void marshall(AttributeValueList attributeValueList, ProtocolMarshaller protocolMarshaller) {
        if (attributeValueList == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(attributeValueList.getIntegerValues(), INTEGERVALUES_BINDING);
            protocolMarshaller.marshall(attributeValueList.getStringValues(), STRINGVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

