/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmincidents.model.Filter;
import com.amazonaws.services.ssmincidents.model.SortOrder;
import com.amazonaws.services.ssmincidents.model.TimelineEventSort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTimelineEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Filter> filters;
    private String incidentRecordArn;
    private Integer maxResults;
    private String nextToken;
    private String sortBy;
    private String sortOrder;

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public ListTimelineEventsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListTimelineEventsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setIncidentRecordArn(String incidentRecordArn) {
        this.incidentRecordArn = incidentRecordArn;
    }

    public String getIncidentRecordArn() {
        return this.incidentRecordArn;
    }

    public ListTimelineEventsRequest withIncidentRecordArn(String incidentRecordArn) {
        this.setIncidentRecordArn(incidentRecordArn);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListTimelineEventsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTimelineEventsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public ListTimelineEventsRequest withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public ListTimelineEventsRequest withSortBy(TimelineEventSort sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public ListTimelineEventsRequest withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public ListTimelineEventsRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getIncidentRecordArn() != null) {
            sb.append("IncidentRecordArn: ").append(this.getIncidentRecordArn()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTimelineEventsRequest)) {
            return false;
        }
        ListTimelineEventsRequest other = (ListTimelineEventsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getIncidentRecordArn() == null ^ this.getIncidentRecordArn() == null) {
            return false;
        }
        if (other.getIncidentRecordArn() != null && !other.getIncidentRecordArn().equals(this.getIncidentRecordArn())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        return other.getSortOrder() == null || other.getSortOrder().equals(this.getSortOrder());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentRecordArn() == null ? 0 : this.getIncidentRecordArn().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        return hashCode;
    }

    @Override
    public ListTimelineEventsRequest clone() {
        return (ListTimelineEventsRequest)super.clone();
    }
}

