/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.Target;

@SdkInternalApi
public class TargetMarshaller {
    private static final MarshallingInfo<StructuredPojo> CHANNELTARGETINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelTargetInfo").build();
    private static final MarshallingInfo<StructuredPojo> CONTACTTARGETINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactTargetInfo").build();
    private static final TargetMarshaller instance = new TargetMarshaller();

    public static TargetMarshaller getInstance() {
        return instance;
    }

    public void marshall(Target target, ProtocolMarshaller protocolMarshaller) {
        if (target == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(target.getChannelTargetInfo(), CHANNELTARGETINFO_BINDING);
            protocolMarshaller.marshall(target.getContactTargetInfo(), CONTACTTARGETINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

