/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.Receipt;
import java.util.Date;

@SdkInternalApi
public class ReceiptMarshaller {
    private static final MarshallingInfo<String> CONTACTCHANNELARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactChannelArn").build();
    private static final MarshallingInfo<String> RECEIPTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceiptType").build();
    private static final MarshallingInfo<String> RECEIPTINFO_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceiptInfo").build();
    private static final MarshallingInfo<Date> RECEIPTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceiptTime").timestampFormat("unixTimestamp").build();
    private static final ReceiptMarshaller instance = new ReceiptMarshaller();

    public static ReceiptMarshaller getInstance() {
        return instance;
    }

    public void marshall(Receipt receipt, ProtocolMarshaller protocolMarshaller) {
        if (receipt == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(receipt.getContactChannelArn(), CONTACTCHANNELARN_BINDING);
            protocolMarshaller.marshall(receipt.getReceiptType(), RECEIPTTYPE_BINDING);
            protocolMarshaller.marshall(receipt.getReceiptInfo(), RECEIPTINFO_BINDING);
            protocolMarshaller.marshall(receipt.getReceiptTime(), RECEIPTTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

