/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.Plan;
import java.util.List;

@SdkInternalApi
public class PlanMarshaller {
    private static final MarshallingInfo<List> STAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stages").build();
    private static final PlanMarshaller instance = new PlanMarshaller();

    public static PlanMarshaller getInstance() {
        return instance;
    }

    public void marshall(Plan plan, ProtocolMarshaller protocolMarshaller) {
        if (plan == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(plan.getStages(), STAGES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

