/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.snowdevicemanagement.model.SoftwareInformation;

@SdkInternalApi
public class SoftwareInformationMarshaller {
    private static final MarshallingInfo<String> INSTALLSTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("installState").build();
    private static final MarshallingInfo<String> INSTALLEDVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("installedVersion").build();
    private static final MarshallingInfo<String> INSTALLINGVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("installingVersion").build();
    private static final SoftwareInformationMarshaller instance = new SoftwareInformationMarshaller();

    public static SoftwareInformationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SoftwareInformation softwareInformation, ProtocolMarshaller protocolMarshaller) {
        if (softwareInformation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(softwareInformation.getInstallState(), INSTALLSTATE_BINDING);
            protocolMarshaller.marshall(softwareInformation.getInstalledVersion(), INSTALLEDVERSION_BINDING);
            protocolMarshaller.marshall(softwareInformation.getInstallingVersion(), INSTALLINGVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

