/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model.transform;

import com.amazonaws.services.route53recoveryreadiness.model.Resource;
import com.amazonaws.services.route53recoveryreadiness.model.transform.DNSTargetResourceJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class ResourceJsonUnmarshaller
implements Unmarshaller<Resource, JsonUnmarshallerContext> {
    private static ResourceJsonUnmarshaller instance;

    @Override
    public Resource unmarshall(JsonUnmarshallerContext context) throws Exception {
        Resource resource = new Resource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("componentId", targetDepth)) {
                    context.nextToken();
                    resource.setComponentId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dnsTargetResource", targetDepth)) {
                    context.nextToken();
                    resource.setDnsTargetResource(DNSTargetResourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("readinessScopes", targetDepth)) {
                    context.nextToken();
                    resource.setReadinessScopes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("resourceArn", targetDepth)) {
                    context.nextToken();
                    resource.setResourceArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return resource;
    }

    public static ResourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonUnmarshaller();
        }
        return instance;
    }
}

