/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateCellRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cellName;
    private List<String> cells;
    private Map<String, String> tags;

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public String getCellName() {
        return this.cellName;
    }

    public CreateCellRequest withCellName(String cellName) {
        this.setCellName(cellName);
        return this;
    }

    public List<String> getCells() {
        return this.cells;
    }

    public void setCells(Collection<String> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<String>(cells);
    }

    public CreateCellRequest withCells(String ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<String>(cells.length));
        }
        for (String ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public CreateCellRequest withCells(Collection<String> cells) {
        this.setCells(cells);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateCellRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateCellRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateCellRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCellName() != null) {
            sb.append("CellName: ").append(this.getCellName()).append(",");
        }
        if (this.getCells() != null) {
            sb.append("Cells: ").append(this.getCells()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCellRequest)) {
            return false;
        }
        CreateCellRequest other = (CreateCellRequest)obj;
        if (other.getCellName() == null ^ this.getCellName() == null) {
            return false;
        }
        if (other.getCellName() != null && !other.getCellName().equals(this.getCellName())) {
            return false;
        }
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        if (other.getCells() != null && !other.getCells().equals(this.getCells())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCellName() == null ? 0 : this.getCellName().hashCode());
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateCellRequest clone() {
        return (CreateCellRequest)super.clone();
    }
}

