/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycontrolconfig.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.route53recoverycontrolconfig.AWSRoute53RecoveryControlConfig;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeClusterRequest;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeClusterResult;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeControlPanelRequest;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeControlPanelResult;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeRoutingControlRequest;
import com.amazonaws.services.route53recoverycontrolconfig.model.DescribeRoutingControlResult;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.ClusterCreated;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.ClusterDeleted;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.ControlPanelCreated;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.ControlPanelDeleted;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.DescribeClusterFunction;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.DescribeControlPanelFunction;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.DescribeRoutingControlFunction;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.RoutingControlCreated;
import com.amazonaws.services.route53recoverycontrolconfig.waiters.RoutingControlDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpFailureStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AWSRoute53RecoveryControlConfigWaiters {
    private final AWSRoute53RecoveryControlConfig client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AWSRoute53RecoveryControlConfigWaiters");

    @SdkInternalApi
    public AWSRoute53RecoveryControlConfigWaiters(AWSRoute53RecoveryControlConfig client) {
        this.client = client;
    }

    public Waiter<DescribeClusterRequest> clusterDeleted() {
        return new WaiterBuilder<DescribeClusterRequest, DescribeClusterResult>().withSdkFunction(new DescribeClusterFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS), new ClusterDeleted.IsPENDING_DELETIONMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeControlPanelRequest> controlPanelDeleted() {
        return new WaiterBuilder<DescribeControlPanelRequest, DescribeControlPanelResult>().withSdkFunction(new DescribeControlPanelFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS), new ControlPanelDeleted.IsPENDING_DELETIONMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeControlPanelRequest> controlPanelCreated() {
        return new WaiterBuilder<DescribeControlPanelRequest, DescribeControlPanelResult>().withSdkFunction(new DescribeControlPanelFunction(this.client)).withAcceptors(new ControlPanelCreated.IsDEPLOYEDMatcher(), new ControlPanelCreated.IsPENDINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeRoutingControlRequest> routingControlDeleted() {
        return new WaiterBuilder<DescribeRoutingControlRequest, DescribeRoutingControlResult>().withSdkFunction(new DescribeRoutingControlFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS), new RoutingControlDeleted.IsPENDING_DELETIONMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeRoutingControlRequest> routingControlCreated() {
        return new WaiterBuilder<DescribeRoutingControlRequest, DescribeRoutingControlResult>().withSdkFunction(new DescribeRoutingControlFunction(this.client)).withAcceptors(new RoutingControlCreated.IsDEPLOYEDMatcher(), new RoutingControlCreated.IsPENDINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterRequest> clusterCreated() {
        return new WaiterBuilder<DescribeClusterRequest, DescribeClusterResult>().withSdkFunction(new DescribeClusterFunction(this.client)).withAcceptors(new ClusterCreated.IsDEPLOYEDMatcher(), new ClusterCreated.IsPENDINGMatcher(), new HttpFailureStatusAcceptor(500, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(26), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

