/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycontrolconfig.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.route53recoverycontrolconfig.model.ClusterEndpoint;

@SdkInternalApi
public class ClusterEndpointMarshaller {
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final ClusterEndpointMarshaller instance = new ClusterEndpointMarshaller();

    public static ClusterEndpointMarshaller getInstance() {
        return instance;
    }

    public void marshall(ClusterEndpoint clusterEndpoint, ProtocolMarshaller protocolMarshaller) {
        if (clusterEndpoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(clusterEndpoint.getEndpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall(clusterEndpoint.getRegion(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

