/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycontrolconfig.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53recoverycontrolconfig.model.RuleConfig;
import com.amazonaws.services.route53recoverycontrolconfig.model.Status;
import com.amazonaws.services.route53recoverycontrolconfig.model.transform.GatingRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GatingRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String controlPanelArn;
    private List<String> gatingControls;
    private String name;
    private RuleConfig ruleConfig;
    private String safetyRuleArn;
    private String status;
    private List<String> targetControls;
    private Integer waitPeriodMs;

    public void setControlPanelArn(String controlPanelArn) {
        this.controlPanelArn = controlPanelArn;
    }

    public String getControlPanelArn() {
        return this.controlPanelArn;
    }

    public GatingRule withControlPanelArn(String controlPanelArn) {
        this.setControlPanelArn(controlPanelArn);
        return this;
    }

    public List<String> getGatingControls() {
        return this.gatingControls;
    }

    public void setGatingControls(Collection<String> gatingControls) {
        if (gatingControls == null) {
            this.gatingControls = null;
            return;
        }
        this.gatingControls = new ArrayList<String>(gatingControls);
    }

    public GatingRule withGatingControls(String ... gatingControls) {
        if (this.gatingControls == null) {
            this.setGatingControls(new ArrayList<String>(gatingControls.length));
        }
        for (String ele : gatingControls) {
            this.gatingControls.add(ele);
        }
        return this;
    }

    public GatingRule withGatingControls(Collection<String> gatingControls) {
        this.setGatingControls(gatingControls);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GatingRule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRuleConfig(RuleConfig ruleConfig) {
        this.ruleConfig = ruleConfig;
    }

    public RuleConfig getRuleConfig() {
        return this.ruleConfig;
    }

    public GatingRule withRuleConfig(RuleConfig ruleConfig) {
        this.setRuleConfig(ruleConfig);
        return this;
    }

    public void setSafetyRuleArn(String safetyRuleArn) {
        this.safetyRuleArn = safetyRuleArn;
    }

    public String getSafetyRuleArn() {
        return this.safetyRuleArn;
    }

    public GatingRule withSafetyRuleArn(String safetyRuleArn) {
        this.setSafetyRuleArn(safetyRuleArn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GatingRule withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GatingRule withStatus(Status status) {
        this.status = status.toString();
        return this;
    }

    public List<String> getTargetControls() {
        return this.targetControls;
    }

    public void setTargetControls(Collection<String> targetControls) {
        if (targetControls == null) {
            this.targetControls = null;
            return;
        }
        this.targetControls = new ArrayList<String>(targetControls);
    }

    public GatingRule withTargetControls(String ... targetControls) {
        if (this.targetControls == null) {
            this.setTargetControls(new ArrayList<String>(targetControls.length));
        }
        for (String ele : targetControls) {
            this.targetControls.add(ele);
        }
        return this;
    }

    public GatingRule withTargetControls(Collection<String> targetControls) {
        this.setTargetControls(targetControls);
        return this;
    }

    public void setWaitPeriodMs(Integer waitPeriodMs) {
        this.waitPeriodMs = waitPeriodMs;
    }

    public Integer getWaitPeriodMs() {
        return this.waitPeriodMs;
    }

    public GatingRule withWaitPeriodMs(Integer waitPeriodMs) {
        this.setWaitPeriodMs(waitPeriodMs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getControlPanelArn() != null) {
            sb.append("ControlPanelArn: ").append(this.getControlPanelArn()).append(",");
        }
        if (this.getGatingControls() != null) {
            sb.append("GatingControls: ").append(this.getGatingControls()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRuleConfig() != null) {
            sb.append("RuleConfig: ").append(this.getRuleConfig()).append(",");
        }
        if (this.getSafetyRuleArn() != null) {
            sb.append("SafetyRuleArn: ").append(this.getSafetyRuleArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTargetControls() != null) {
            sb.append("TargetControls: ").append(this.getTargetControls()).append(",");
        }
        if (this.getWaitPeriodMs() != null) {
            sb.append("WaitPeriodMs: ").append(this.getWaitPeriodMs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatingRule)) {
            return false;
        }
        GatingRule other = (GatingRule)obj;
        if (other.getControlPanelArn() == null ^ this.getControlPanelArn() == null) {
            return false;
        }
        if (other.getControlPanelArn() != null && !other.getControlPanelArn().equals(this.getControlPanelArn())) {
            return false;
        }
        if (other.getGatingControls() == null ^ this.getGatingControls() == null) {
            return false;
        }
        if (other.getGatingControls() != null && !other.getGatingControls().equals(this.getGatingControls())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRuleConfig() == null ^ this.getRuleConfig() == null) {
            return false;
        }
        if (other.getRuleConfig() != null && !other.getRuleConfig().equals(this.getRuleConfig())) {
            return false;
        }
        if (other.getSafetyRuleArn() == null ^ this.getSafetyRuleArn() == null) {
            return false;
        }
        if (other.getSafetyRuleArn() != null && !other.getSafetyRuleArn().equals(this.getSafetyRuleArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTargetControls() == null ^ this.getTargetControls() == null) {
            return false;
        }
        if (other.getTargetControls() != null && !other.getTargetControls().equals(this.getTargetControls())) {
            return false;
        }
        if (other.getWaitPeriodMs() == null ^ this.getWaitPeriodMs() == null) {
            return false;
        }
        return other.getWaitPeriodMs() == null || other.getWaitPeriodMs().equals(this.getWaitPeriodMs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getControlPanelArn() == null ? 0 : this.getControlPanelArn().hashCode());
        hashCode = 31 * hashCode + (this.getGatingControls() == null ? 0 : this.getGatingControls().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRuleConfig() == null ? 0 : this.getRuleConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSafetyRuleArn() == null ? 0 : this.getSafetyRuleArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTargetControls() == null ? 0 : this.getTargetControls().hashCode());
        hashCode = 31 * hashCode + (this.getWaitPeriodMs() == null ? 0 : this.getWaitPeriodMs().hashCode());
        return hashCode;
    }

    public GatingRule clone() {
        try {
            return (GatingRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GatingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

