/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoverycluster;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryCluster;
import com.amazonaws.services.route53recoverycluster.AWSRoute53RecoveryClusterClientBuilder;
import com.amazonaws.services.route53recoverycluster.model.AWSRoute53RecoveryClusterException;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.GetRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStateResult;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesRequest;
import com.amazonaws.services.route53recoverycluster.model.UpdateRoutingControlStatesResult;
import com.amazonaws.services.route53recoverycluster.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.EndpointTemporarilyUnavailableExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.GetRoutingControlStateRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.GetRoutingControlStateResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStateRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStateResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStatesRequestProtocolMarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.UpdateRoutingControlStatesResultJsonUnmarshaller;
import com.amazonaws.services.route53recoverycluster.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.thirdparty.apache.logging.Log;
import com.amazonaws.thirdparty.apache.logging.LogFactory;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;

@ThreadSafe
public class AWSRoute53RecoveryClusterClient
extends AmazonWebServiceClient
implements AWSRoute53RecoveryCluster {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSRoute53RecoveryCluster.class);
    private static final String DEFAULT_SIGNING_NAME = "route53-recovery-cluster";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller(AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller(ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller(ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller(InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EndpointTemporarilyUnavailableException").withExceptionUnmarshaller(EndpointTemporarilyUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller(ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller(ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSRoute53RecoveryClusterException.class));

    public static AWSRoute53RecoveryClusterClientBuilder builder() {
        return AWSRoute53RecoveryClusterClientBuilder.standard();
    }

    AWSRoute53RecoveryClusterClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSRoute53RecoveryClusterClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("route53-recovery-cluster.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53recoverycluster/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/route53recoverycluster/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetRoutingControlStateResult getRoutingControlState(GetRoutingControlStateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetRoutingControlState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRoutingControlStateResult executeGetRoutingControlState(GetRoutingControlStateRequest getRoutingControlStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRoutingControlStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRoutingControlStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRoutingControlStateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(getRoutingControlStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "GetRoutingControlState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRoutingControlStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRoutingControlStateResult getRoutingControlStateResult = (GetRoutingControlStateResult)response.getAwsResponse();
            return getRoutingControlStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRoutingControlStateResult updateRoutingControlState(UpdateRoutingControlStateRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRoutingControlState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRoutingControlStateResult executeUpdateRoutingControlState(UpdateRoutingControlStateRequest updateRoutingControlStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRoutingControlStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRoutingControlStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRoutingControlStateRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRoutingControlStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRoutingControlState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRoutingControlStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRoutingControlStateResult updateRoutingControlStateResult = (UpdateRoutingControlStateResult)response.getAwsResponse();
            return updateRoutingControlStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRoutingControlStatesResult updateRoutingControlStates(UpdateRoutingControlStatesRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRoutingControlStates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRoutingControlStatesResult executeUpdateRoutingControlStates(UpdateRoutingControlStatesRequest updateRoutingControlStatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRoutingControlStatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRoutingControlStatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRoutingControlStatesRequestProtocolMarshaller(protocolFactory).marshall(super.beforeMarshalling(updateRoutingControlStatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, "Route53 Recovery Cluster");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, "UpdateRoutingControlStates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRoutingControlStatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRoutingControlStatesResult updateRoutingControlStatesResult = (UpdateRoutingControlStatesResult)response.getAwsResponse();
            return updateRoutingControlStatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

