/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.proton.model.S3ObjectSource;

@SdkInternalApi
public class S3ObjectSourceMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final S3ObjectSourceMarshaller instance = new S3ObjectSourceMarshaller();

    public static S3ObjectSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ObjectSource s3ObjectSource, ProtocolMarshaller protocolMarshaller) {
        if (s3ObjectSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3ObjectSource.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall(s3ObjectSource.getKey(), KEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

