/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model.transform;

import com.amazonaws.services.proton.model.S3ObjectSource;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class S3ObjectSourceJsonUnmarshaller
implements Unmarshaller<S3ObjectSource, JsonUnmarshallerContext> {
    private static S3ObjectSourceJsonUnmarshaller instance;

    @Override
    public S3ObjectSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3ObjectSource s3ObjectSource = new S3ObjectSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucket", targetDepth)) {
                    context.nextToken();
                    s3ObjectSource.setBucket(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("key", targetDepth)) {
                    context.nextToken();
                    s3ObjectSource.setKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3ObjectSource;
    }

    public static S3ObjectSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectSourceJsonUnmarshaller();
        }
        return instance;
    }
}

