/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.proton.model.CompatibleEnvironmentTemplate;

@SdkInternalApi
public class CompatibleEnvironmentTemplateMarshaller {
    private static final MarshallingInfo<String> MAJORVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("majorVersion").build();
    private static final MarshallingInfo<String> TEMPLATENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateName").build();
    private static final CompatibleEnvironmentTemplateMarshaller instance = new CompatibleEnvironmentTemplateMarshaller();

    public static CompatibleEnvironmentTemplateMarshaller getInstance() {
        return instance;
    }

    public void marshall(CompatibleEnvironmentTemplate compatibleEnvironmentTemplate, ProtocolMarshaller protocolMarshaller) {
        if (compatibleEnvironmentTemplate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(compatibleEnvironmentTemplate.getMajorVersion(), MAJORVERSION_BINDING);
            protocolMarshaller.marshall(compatibleEnvironmentTemplate.getTemplateName(), TEMPLATENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

