/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.LaunchProfileInitializationActiveDirectory;
import com.amazonaws.services.nimblestudio.model.LaunchProfileInitializationScript;
import com.amazonaws.services.nimblestudio.model.LaunchProfilePlatform;
import com.amazonaws.services.nimblestudio.model.transform.LaunchProfileInitializationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LaunchProfileInitialization
implements Serializable,
Cloneable,
StructuredPojo {
    private LaunchProfileInitializationActiveDirectory activeDirectory;
    private List<String> ec2SecurityGroupIds;
    private String launchProfileId;
    private String launchProfileProtocolVersion;
    private String launchPurpose;
    private String name;
    private String platform;
    private List<LaunchProfileInitializationScript> systemInitializationScripts;
    private List<LaunchProfileInitializationScript> userInitializationScripts;

    public void setActiveDirectory(LaunchProfileInitializationActiveDirectory activeDirectory) {
        this.activeDirectory = activeDirectory;
    }

    public LaunchProfileInitializationActiveDirectory getActiveDirectory() {
        return this.activeDirectory;
    }

    public LaunchProfileInitialization withActiveDirectory(LaunchProfileInitializationActiveDirectory activeDirectory) {
        this.setActiveDirectory(activeDirectory);
        return this;
    }

    public List<String> getEc2SecurityGroupIds() {
        return this.ec2SecurityGroupIds;
    }

    public void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
        if (ec2SecurityGroupIds == null) {
            this.ec2SecurityGroupIds = null;
            return;
        }
        this.ec2SecurityGroupIds = new ArrayList<String>(ec2SecurityGroupIds);
    }

    public LaunchProfileInitialization withEc2SecurityGroupIds(String ... ec2SecurityGroupIds) {
        if (this.ec2SecurityGroupIds == null) {
            this.setEc2SecurityGroupIds(new ArrayList<String>(ec2SecurityGroupIds.length));
        }
        for (String ele : ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds.add(ele);
        }
        return this;
    }

    public LaunchProfileInitialization withEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
        this.setEc2SecurityGroupIds(ec2SecurityGroupIds);
        return this;
    }

    public void setLaunchProfileId(String launchProfileId) {
        this.launchProfileId = launchProfileId;
    }

    public String getLaunchProfileId() {
        return this.launchProfileId;
    }

    public LaunchProfileInitialization withLaunchProfileId(String launchProfileId) {
        this.setLaunchProfileId(launchProfileId);
        return this;
    }

    public void setLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
        this.launchProfileProtocolVersion = launchProfileProtocolVersion;
    }

    public String getLaunchProfileProtocolVersion() {
        return this.launchProfileProtocolVersion;
    }

    public LaunchProfileInitialization withLaunchProfileProtocolVersion(String launchProfileProtocolVersion) {
        this.setLaunchProfileProtocolVersion(launchProfileProtocolVersion);
        return this;
    }

    public void setLaunchPurpose(String launchPurpose) {
        this.launchPurpose = launchPurpose;
    }

    public String getLaunchPurpose() {
        return this.launchPurpose;
    }

    public LaunchProfileInitialization withLaunchPurpose(String launchPurpose) {
        this.setLaunchPurpose(launchPurpose);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LaunchProfileInitialization withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public LaunchProfileInitialization withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public LaunchProfileInitialization withPlatform(LaunchProfilePlatform platform) {
        this.platform = platform.toString();
        return this;
    }

    public List<LaunchProfileInitializationScript> getSystemInitializationScripts() {
        return this.systemInitializationScripts;
    }

    public void setSystemInitializationScripts(Collection<LaunchProfileInitializationScript> systemInitializationScripts) {
        if (systemInitializationScripts == null) {
            this.systemInitializationScripts = null;
            return;
        }
        this.systemInitializationScripts = new ArrayList<LaunchProfileInitializationScript>(systemInitializationScripts);
    }

    public LaunchProfileInitialization withSystemInitializationScripts(LaunchProfileInitializationScript ... systemInitializationScripts) {
        if (this.systemInitializationScripts == null) {
            this.setSystemInitializationScripts(new ArrayList<LaunchProfileInitializationScript>(systemInitializationScripts.length));
        }
        for (LaunchProfileInitializationScript ele : systemInitializationScripts) {
            this.systemInitializationScripts.add(ele);
        }
        return this;
    }

    public LaunchProfileInitialization withSystemInitializationScripts(Collection<LaunchProfileInitializationScript> systemInitializationScripts) {
        this.setSystemInitializationScripts(systemInitializationScripts);
        return this;
    }

    public List<LaunchProfileInitializationScript> getUserInitializationScripts() {
        return this.userInitializationScripts;
    }

    public void setUserInitializationScripts(Collection<LaunchProfileInitializationScript> userInitializationScripts) {
        if (userInitializationScripts == null) {
            this.userInitializationScripts = null;
            return;
        }
        this.userInitializationScripts = new ArrayList<LaunchProfileInitializationScript>(userInitializationScripts);
    }

    public LaunchProfileInitialization withUserInitializationScripts(LaunchProfileInitializationScript ... userInitializationScripts) {
        if (this.userInitializationScripts == null) {
            this.setUserInitializationScripts(new ArrayList<LaunchProfileInitializationScript>(userInitializationScripts.length));
        }
        for (LaunchProfileInitializationScript ele : userInitializationScripts) {
            this.userInitializationScripts.add(ele);
        }
        return this;
    }

    public LaunchProfileInitialization withUserInitializationScripts(Collection<LaunchProfileInitializationScript> userInitializationScripts) {
        this.setUserInitializationScripts(userInitializationScripts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActiveDirectory() != null) {
            sb.append("ActiveDirectory: ").append(this.getActiveDirectory()).append(",");
        }
        if (this.getEc2SecurityGroupIds() != null) {
            sb.append("Ec2SecurityGroupIds: ").append(this.getEc2SecurityGroupIds()).append(",");
        }
        if (this.getLaunchProfileId() != null) {
            sb.append("LaunchProfileId: ").append(this.getLaunchProfileId()).append(",");
        }
        if (this.getLaunchProfileProtocolVersion() != null) {
            sb.append("LaunchProfileProtocolVersion: ").append(this.getLaunchProfileProtocolVersion()).append(",");
        }
        if (this.getLaunchPurpose() != null) {
            sb.append("LaunchPurpose: ").append(this.getLaunchPurpose()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getSystemInitializationScripts() != null) {
            sb.append("SystemInitializationScripts: ").append(this.getSystemInitializationScripts()).append(",");
        }
        if (this.getUserInitializationScripts() != null) {
            sb.append("UserInitializationScripts: ").append(this.getUserInitializationScripts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfileInitialization)) {
            return false;
        }
        LaunchProfileInitialization other = (LaunchProfileInitialization)obj;
        if (other.getActiveDirectory() == null ^ this.getActiveDirectory() == null) {
            return false;
        }
        if (other.getActiveDirectory() != null && !other.getActiveDirectory().equals(this.getActiveDirectory())) {
            return false;
        }
        if (other.getEc2SecurityGroupIds() == null ^ this.getEc2SecurityGroupIds() == null) {
            return false;
        }
        if (other.getEc2SecurityGroupIds() != null && !other.getEc2SecurityGroupIds().equals(this.getEc2SecurityGroupIds())) {
            return false;
        }
        if (other.getLaunchProfileId() == null ^ this.getLaunchProfileId() == null) {
            return false;
        }
        if (other.getLaunchProfileId() != null && !other.getLaunchProfileId().equals(this.getLaunchProfileId())) {
            return false;
        }
        if (other.getLaunchProfileProtocolVersion() == null ^ this.getLaunchProfileProtocolVersion() == null) {
            return false;
        }
        if (other.getLaunchProfileProtocolVersion() != null && !other.getLaunchProfileProtocolVersion().equals(this.getLaunchProfileProtocolVersion())) {
            return false;
        }
        if (other.getLaunchPurpose() == null ^ this.getLaunchPurpose() == null) {
            return false;
        }
        if (other.getLaunchPurpose() != null && !other.getLaunchPurpose().equals(this.getLaunchPurpose())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getSystemInitializationScripts() == null ^ this.getSystemInitializationScripts() == null) {
            return false;
        }
        if (other.getSystemInitializationScripts() != null && !other.getSystemInitializationScripts().equals(this.getSystemInitializationScripts())) {
            return false;
        }
        if (other.getUserInitializationScripts() == null ^ this.getUserInitializationScripts() == null) {
            return false;
        }
        return other.getUserInitializationScripts() == null || other.getUserInitializationScripts().equals(this.getUserInitializationScripts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActiveDirectory() == null ? 0 : this.getActiveDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SecurityGroupIds() == null ? 0 : this.getEc2SecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchProfileId() == null ? 0 : this.getLaunchProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchProfileProtocolVersion() == null ? 0 : this.getLaunchProfileProtocolVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchPurpose() == null ? 0 : this.getLaunchPurpose().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getSystemInitializationScripts() == null ? 0 : this.getSystemInitializationScripts().hashCode());
        hashCode = 31 * hashCode + (this.getUserInitializationScripts() == null ? 0 : this.getUserInitializationScripts().hashCode());
        return hashCode;
    }

    public LaunchProfileInitialization clone() {
        try {
            return (LaunchProfileInitialization)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LaunchProfileInitializationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

