/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.ActiveDirectoryComputerAttribute;
import com.amazonaws.services.nimblestudio.model.transform.ActiveDirectoryConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ActiveDirectoryConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ActiveDirectoryComputerAttribute> computerAttributes;
    private String directoryId;
    private String organizationalUnitDistinguishedName;

    public List<ActiveDirectoryComputerAttribute> getComputerAttributes() {
        return this.computerAttributes;
    }

    public void setComputerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
        if (computerAttributes == null) {
            this.computerAttributes = null;
            return;
        }
        this.computerAttributes = new ArrayList<ActiveDirectoryComputerAttribute>(computerAttributes);
    }

    public ActiveDirectoryConfiguration withComputerAttributes(ActiveDirectoryComputerAttribute ... computerAttributes) {
        if (this.computerAttributes == null) {
            this.setComputerAttributes(new ArrayList<ActiveDirectoryComputerAttribute>(computerAttributes.length));
        }
        for (ActiveDirectoryComputerAttribute ele : computerAttributes) {
            this.computerAttributes.add(ele);
        }
        return this;
    }

    public ActiveDirectoryConfiguration withComputerAttributes(Collection<ActiveDirectoryComputerAttribute> computerAttributes) {
        this.setComputerAttributes(computerAttributes);
        return this;
    }

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public ActiveDirectoryConfiguration withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
        this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
    }

    public String getOrganizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public ActiveDirectoryConfiguration withOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
        this.setOrganizationalUnitDistinguishedName(organizationalUnitDistinguishedName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComputerAttributes() != null) {
            sb.append("ComputerAttributes: ").append(this.getComputerAttributes()).append(",");
        }
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getOrganizationalUnitDistinguishedName() != null) {
            sb.append("OrganizationalUnitDistinguishedName: ").append(this.getOrganizationalUnitDistinguishedName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveDirectoryConfiguration)) {
            return false;
        }
        ActiveDirectoryConfiguration other = (ActiveDirectoryConfiguration)obj;
        if (other.getComputerAttributes() == null ^ this.getComputerAttributes() == null) {
            return false;
        }
        if (other.getComputerAttributes() != null && !other.getComputerAttributes().equals(this.getComputerAttributes())) {
            return false;
        }
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getOrganizationalUnitDistinguishedName() == null ^ this.getOrganizationalUnitDistinguishedName() == null) {
            return false;
        }
        return other.getOrganizationalUnitDistinguishedName() == null || other.getOrganizationalUnitDistinguishedName().equals(this.getOrganizationalUnitDistinguishedName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComputerAttributes() == null ? 0 : this.getComputerAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getOrganizationalUnitDistinguishedName() == null ? 0 : this.getOrganizationalUnitDistinguishedName().hashCode());
        return hashCode;
    }

    public ActiveDirectoryConfiguration clone() {
        try {
            return (ActiveDirectoryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActiveDirectoryConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

