/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mgn.model.LaunchedInstance;

@SdkInternalApi
public class LaunchedInstanceMarshaller {
    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2InstanceID").build();
    private static final MarshallingInfo<String> FIRSTBOOT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstBoot").build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobID").build();
    private static final LaunchedInstanceMarshaller instance = new LaunchedInstanceMarshaller();

    public static LaunchedInstanceMarshaller getInstance() {
        return instance;
    }

    public void marshall(LaunchedInstance launchedInstance, ProtocolMarshaller protocolMarshaller) {
        if (launchedInstance == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(launchedInstance.getEc2InstanceID(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall(launchedInstance.getFirstBoot(), FIRSTBOOT_BINDING);
            protocolMarshaller.marshall(launchedInstance.getJobID(), JOBID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

