/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mgn.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mgn.model.transform.NetworkInterfaceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkInterface
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> ips;
    private Boolean isPrimary;
    private String macAddress;

    public List<String> getIps() {
        return this.ips;
    }

    public void setIps(Collection<String> ips) {
        if (ips == null) {
            this.ips = null;
            return;
        }
        this.ips = new ArrayList<String>(ips);
    }

    public NetworkInterface withIps(String ... ips) {
        if (this.ips == null) {
            this.setIps(new ArrayList<String>(ips.length));
        }
        for (String ele : ips) {
            this.ips.add(ele);
        }
        return this;
    }

    public NetworkInterface withIps(Collection<String> ips) {
        this.setIps(ips);
        return this;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public NetworkInterface withIsPrimary(Boolean isPrimary) {
        this.setIsPrimary(isPrimary);
        return this;
    }

    public Boolean isPrimary() {
        return this.isPrimary;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public NetworkInterface withMacAddress(String macAddress) {
        this.setMacAddress(macAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIps() != null) {
            sb.append("Ips: ").append(this.getIps()).append(",");
        }
        if (this.getIsPrimary() != null) {
            sb.append("IsPrimary: ").append(this.getIsPrimary()).append(",");
        }
        if (this.getMacAddress() != null) {
            sb.append("MacAddress: ").append(this.getMacAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface)obj;
        if (other.getIps() == null ^ this.getIps() == null) {
            return false;
        }
        if (other.getIps() != null && !other.getIps().equals(this.getIps())) {
            return false;
        }
        if (other.getIsPrimary() == null ^ this.getIsPrimary() == null) {
            return false;
        }
        if (other.getIsPrimary() != null && !other.getIsPrimary().equals(this.getIsPrimary())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        return other.getMacAddress() == null || other.getMacAddress().equals(this.getMacAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIps() == null ? 0 : this.getIps().hashCode());
        hashCode = 31 * hashCode + (this.getIsPrimary() == null ? 0 : this.getIsPrimary().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        return hashCode;
    }

    public NetworkInterface clone() {
        try {
            return (NetworkInterface)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkInterfaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

