/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutmetrics.model.VpcConfiguration;
import java.util.List;

@SdkInternalApi
public class VpcConfigurationMarshaller {
    private static final MarshallingInfo<List> SUBNETIDLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIdList").build();
    private static final MarshallingInfo<List> SECURITYGROUPIDLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityGroupIdList").build();
    private static final VpcConfigurationMarshaller instance = new VpcConfigurationMarshaller();

    public static VpcConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(VpcConfiguration vpcConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (vpcConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(vpcConfiguration.getSubnetIdList(), SUBNETIDLIST_BINDING);
            protocolMarshaller.marshall(vpcConfiguration.getSecurityGroupIdList(), SECURITYGROUPIDLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

