/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutmetrics.model.TimeSeries;
import java.util.List;

@SdkInternalApi
public class TimeSeriesMarshaller {
    private static final MarshallingInfo<String> TIMESERIESID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeSeriesId").build();
    private static final MarshallingInfo<List> DIMENSIONLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DimensionList").build();
    private static final MarshallingInfo<List> METRICVALUELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricValueList").build();
    private static final TimeSeriesMarshaller instance = new TimeSeriesMarshaller();

    public static TimeSeriesMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimeSeries timeSeries, ProtocolMarshaller protocolMarshaller) {
        if (timeSeries == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(timeSeries.getTimeSeriesId(), TIMESERIESID_BINDING);
            protocolMarshaller.marshall(timeSeries.getDimensionList(), DIMENSIONLIST_BINDING);
            protocolMarshaller.marshall(timeSeries.getMetricValueList(), METRICVALUELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

