/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.S3SourceConfig;
import java.util.List;

@SdkInternalApi
public class S3SourceConfigMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<List> TEMPLATEDPATHLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TemplatedPathList").build();
    private static final MarshallingInfo<List> HISTORICALDATAPATHLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HistoricalDataPathList").build();
    private static final MarshallingInfo<StructuredPojo> FILEFORMATDESCRIPTOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileFormatDescriptor").build();
    private static final S3SourceConfigMarshaller instance = new S3SourceConfigMarshaller();

    public static S3SourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3SourceConfig s3SourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (s3SourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3SourceConfig.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(s3SourceConfig.getTemplatedPathList(), TEMPLATEDPATHLIST_BINDING);
            protocolMarshaller.marshall(s3SourceConfig.getHistoricalDataPathList(), HISTORICALDATAPATHLIST_BINDING);
            protocolMarshaller.marshall(s3SourceConfig.getFileFormatDescriptor(), FILEFORMATDESCRIPTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

