/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.RedshiftSourceConfig;

@SdkInternalApi
public class RedshiftSourceConfigMarshaller {
    private static final MarshallingInfo<String> CLUSTERIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterIdentifier").build();
    private static final MarshallingInfo<String> DATABASEHOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseHost").build();
    private static final MarshallingInfo<Integer> DATABASEPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabasePort").build();
    private static final MarshallingInfo<String> SECRETMANAGERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretManagerArn").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final RedshiftSourceConfigMarshaller instance = new RedshiftSourceConfigMarshaller();

    public static RedshiftSourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(RedshiftSourceConfig redshiftSourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (redshiftSourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(redshiftSourceConfig.getClusterIdentifier(), CLUSTERIDENTIFIER_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getDatabaseHost(), DATABASEHOST_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getDatabasePort(), DATABASEPORT_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getSecretManagerArn(), SECRETMANAGERARN_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(redshiftSourceConfig.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

