/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.RDSSourceConfig;

@SdkInternalApi
public class RDSSourceConfigMarshaller {
    private static final MarshallingInfo<String> DBINSTANCEIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DBInstanceIdentifier").build();
    private static final MarshallingInfo<String> DATABASEHOST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseHost").build();
    private static final MarshallingInfo<Integer> DATABASEPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabasePort").build();
    private static final MarshallingInfo<String> SECRETMANAGERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretManagerArn").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<StructuredPojo> VPCCONFIGURATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcConfiguration").build();
    private static final RDSSourceConfigMarshaller instance = new RDSSourceConfigMarshaller();

    public static RDSSourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(RDSSourceConfig rDSSourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (rDSSourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(rDSSourceConfig.getDBInstanceIdentifier(), DBINSTANCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getDatabaseHost(), DATABASEHOST_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getDatabasePort(), DATABASEPORT_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getSecretManagerArn(), SECRETMANAGERARN_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(rDSSourceConfig.getVpcConfiguration(), VPCCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

