/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.MetricSource;

@SdkInternalApi
public class MetricSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3SOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3SourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> APPFLOWCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppFlowConfig").build();
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchConfig").build();
    private static final MarshallingInfo<StructuredPojo> RDSSOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RDSSourceConfig").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTSOURCECONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftSourceConfig").build();
    private static final MetricSourceMarshaller instance = new MetricSourceMarshaller();

    public static MetricSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricSource metricSource, ProtocolMarshaller protocolMarshaller) {
        if (metricSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metricSource.getS3SourceConfig(), S3SOURCECONFIG_BINDING);
            protocolMarshaller.marshall(metricSource.getAppFlowConfig(), APPFLOWCONFIG_BINDING);
            protocolMarshaller.marshall(metricSource.getCloudWatchConfig(), CLOUDWATCHCONFIG_BINDING);
            protocolMarshaller.marshall(metricSource.getRDSSourceConfig(), RDSSOURCECONFIG_BINDING);
            protocolMarshaller.marshall(metricSource.getRedshiftSourceConfig(), REDSHIFTSOURCECONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

