/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lookoutmetrics.model.Metric;

@SdkInternalApi
public class MetricMarshaller {
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<String> AGGREGATIONFUNCTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AggregationFunction").build();
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").build();
    private static final MetricMarshaller instance = new MetricMarshaller();

    public static MetricMarshaller getInstance() {
        return instance;
    }

    public void marshall(Metric metric, ProtocolMarshaller protocolMarshaller) {
        if (metric == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(metric.getMetricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall(metric.getAggregationFunction(), AGGREGATIONFUNCTION_BINDING);
            protocolMarshaller.marshall(metric.getNamespace(), NAMESPACE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

